/*-
 * Copyright (c) 1995 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI if_token.h,v 2.7 1999/08/11 20:34:07 dab Exp
 */

#ifndef _IF_TOKEN_H_
#define _IF_TOKEN_H_

/*
 * Definitions for token ring;
 * based on code from Roger Florkowski.
 */

/* Bridge and routing field parameters */
#define ACF_PRIORITY3           0x00    /* priority level 3             */
#define ACF_TOKEN               0x10    /* frame/token                  */
#define FCF_LLC_FRAME           0x40    /* for frame control field      */

#define	RCF0_ALL_BROADCAST	0x80	/* all routes broadcast         */
#define	RCF0_SINGLE_BROADCAST	0xc0	/* single route broadcast       */
#define	RCF0_NON_BROADCAST	0x00	/* not broadcast                */
#define	RCF0_BCAST_MASK		0xe0	/* mask for broadcast handling  */
#define	RCF0_LEN_MASK		0x1f	/* length field in routing control */

#define	RCF1_DIRECTION		0x80	/* direction                    */
#define	RCF1_FRAME0		0x00	/*  516 max LLC pkt             */
#define	RCF1_FRAME0_MAX		516
#define	RCF1_FRAME1		0x10	/* 1500 max LLC pkt             */
#define	RCF1_FRAME1_MAX		1500
#define	RCF1_FRAME2		0x20	/* 2052 max LLC pkt             */
#define	RCF1_FRAME2_MAX		2052
#define	RCF1_FRAME3		0x30	/* 4472 max LLC pkt             */
#define	RCF1_FRAME3_MAX		4472
#define	RCF1_FRAME4		0x40	/* 8144 max LLC pkt             */
#define	RCF1_FRAME4_MAX		8144
#define	RCF1_FRAME5		0x50	/* 11407 max LLC pkt            */
#define	RCF1_FRAME5_MAX		11407
#define	RCF1_FRAME6		0x60	/* 17800 max LLC pkt            */
#define	RCF1_FRAME6_MAX		17800
#define	RCF1_FRAME_MASK		0x70	/* mask for frame bits          */

#define RI_PRESENT              0x80    /* turn on bit 0 of byte 0 src addr */

#define MAX_BRIDGE		8	/* maximum hop count */

#define ISO88025_ADDR_LEN	6	/* address size */
#define ISO88025_MTU		2000	/* Default maximum transmission unit */
#define ISO88025_MTU_4MB	4464	/* 4MB maximum transmission unit */
#define ISO88025_MTU_16MB	17960	/* 16MB maximum transmission unit */

/* 802.5 token ring MAC header */
struct token_header {
	u_int8_t	token_acf;		/* Access control field */
	u_int8_t	token_fcf;		/* Frame control field */
	u_int8_t	token_dhost[ISO88025_ADDR_LEN];
	u_int8_t	token_shost[ISO88025_ADDR_LEN];
};

/*
 * Routing Control (first 16 bits of Routing Information Field)
 * We use two 8-bit fields to avoid byte ordering problems.
 */
struct token_rif {
	u_int8_t	rcf0;
	u_int8_t	rcf1;
	u_int16_t	rseg[MAX_BRIDGE];     /* 0-8 Route Designator fields */
};

/*
 * Maximal token ring header: normal MAC header, then full-sized RIF
 */
struct token_max_hdr {
	struct	token_header hdr;
	struct	token_rif rif;
};

#define HAS_ROUTE(mac) \
	(((struct token_header *)(mac))->token_shost[0] & RI_PRESENT)
#define ROUTE_BYTES(mac) \
	(((struct token_max_hdr *)(mac))->rif.rcf0 & RCF0_LEN_MASK)
#define TOKEN_MAC_SIZE(mac) \
	(sizeof(struct token_header) + (HAS_ROUTE(mac) ? ROUTE_BYTES(mac) : 0))

/*
 * 802.5 data-link sockaddr.  Contains enough room for complete mac + llc.
 * use "real" sockaddr_dl for casting.  This one for easy size calculations.
 */
struct sockaddr_dl_8025 {
	u_char	sdl_len;	/* Total length of sockaddr */
	u_char	sdl_family;	/* AF_DLI */
	u_short	sdl_index;	/* if != 0, system given index for interface */
	u_char	sdl_type;	/* interface type */
	u_char	sdl_nlen;	/* interface name length, no trailing 0 reqd. */
	u_char	sdl_alen;	/* link level address length */
	u_char	sdl_slen;	/* link layer selector length */
	char	sdl_data[46];	/* minimum work area, can be larger;
				   contains both if name and ll address */
};

#ifdef KERNEL
void	token_attach __P((struct ifnet *));
int	token_output __P((struct ifnet *, struct mbuf *, struct sockaddr *,
			struct rtentry *));
void	token_input __P((struct ifnet *, struct mbuf *));
int	token_ioctl __P((struct ifnet *, int, caddr_t));
int	token_sysctl __P((struct ifnet *, int *, u_int, void *, size_t *,
	    void *, size_t));
#endif

#define	TOKENCTL_MULTIADDRS	1	/* Return list of multicast addresses */
#define	TOKENCTL_MAXID		2

#define	TOKENCTL_NAMES {		\
	{ 0, 0 },			\
	{ "multiaddrs", CTLTYPE_STRUCT }, \
}

#endif /* !_IF_TOKEN_H_ */
