/*	BSDI if_types.h,v 2.13 2000/09/25 17:28:38 dab Exp	*/

/*
 * Copyright (c) 1989, 1993, 1994
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)if_types.h	8.2 (Berkeley) 4/20/94
 */

#ifndef _IF_TYPES_H_
#define _IF_TYPES_H_

/*
 * Interface types for benefit of parsing media address headers.
 * This list is derived from the SNMP list of ifTypes.
 *
 * This list comes from the IANA
 * As of August 30, 2000, the list was located at
 *
 *	http://www.isi.edu/in-notes/iana/assignments/smi-numbers
 *
 * If it is gone from there, start looking at http://www.iana.org
 */

#define	IFT_NONE		0x0	/* not yet itialized (not in RFC1573) */

#define	IFT_OTHER		0x1	/* none of the following */
#define	IFT_1822		0x2	/* old-style arpanet imp */
#define	IFT_HDH1822		0x3	/* HDH arpanet imp */
#define	IFT_X25DDN		0x4	/* x25 to imp */
#define	IFT_X25			0x5	/* PDN X25 interface (RFC877) */
#define	IFT_ETHER		0x6	/* Ethernet CSMACD */
#define	IFT_ISO88023		0x7	/* CMSA CD */
#define	IFT_ISO88024		0x8	/* Token Bus */
#define	IFT_ISO88025		0x9	/* Token Ring */
#define	IFT_ISO88026		0xa	/* MAN */
#define	IFT_STARLAN		0xb
#define	IFT_P10			0xc	/* Proteon 10MBit ring */
#define	IFT_P80			0xd	/* Proteon 10MBit ring */
#define	IFT_HY			0xe	/* Hyperchannel */
#define	IFT_FDDI		0xf
#define	IFT_LAPB		0x10
#define	IFT_SDLC		0x11
#define	IFT_T1			0x12
#define	IFT_CEPT		0x13	/* E1 - european T1 */
#define	IFT_ISDNBASIC		0x14
#define	IFT_ISDNPRIMARY		0x15
#define	IFT_PTPSERIAL		0x16	/* Proprietary PTP serial */
#define	IFT_PPP			0x17	/* RFC 1331 */
#define	IFT_LOOP		0x18	/* loopback */
#define	IFT_EON			0x19	/* ISO over IP */
#define	IFT_XETHER		0x1a	/* obsolete 3MB experimental ethernet */
#define	IFT_NSIP		0x1b	/* XNS over IP */
#define	IFT_SLIP		0x1c	/* IP over generic TTY */
#define	IFT_ULTRA		0x1d	/* Ultra Technologies */
#define	IFT_DS3			0x1e	/* Generic T3 */
#define	IFT_SIP			0x1f	/* SMDS */
#define	IFT_FRELAY		0x20	/* Frame Relay DTE only */
#define	IFT_RS232		0x21
#define	IFT_PARA		0x22	/* parallel-port */
#define	IFT_ARCNET		0x23
#define	IFT_ARCNETPLUS		0x24
#define	IFT_ATM			0x25	/* ATM cells */
#define	IFT_MIOX25		0x26
#define	IFT_SONET		0x27	/* SONET or SDH */
#define	IFT_X25PLE		0x28
#define	IFT_ISO88022LLC		0x29
#define	IFT_LOCALTALK		0x2a
#define	IFT_SMDSDXI		0x2b
#define	IFT_FRELAYDCE		0x2c	/* Frame Relay DCE */
#define	IFT_V35			0x2d
#define	IFT_HSSI		0x2e
#define	IFT_HIPPI		0x2f
#define	IFT_MODEM		0x30	/* Generic Modem */
#define	IFT_AAL5		0x31	/* AAL5 over ATM */
#define	IFT_SONETPATH		0x32
#define	IFT_SONETVT		0x33
#define	IFT_SMDSICIP		0x34	/* SMDS InterCarrier Interface */
#define	IFT_PROPVIRTUAL		0x35	/* Proprietary Virtual/internal */
#define	IFT_PROPMUX		0x36	/* Proprietary Multiplexing */

/*
 * Everything above this point is in hex for historical reasons
 * Below this poin we switch to decimal as that is what the documents use
 */

#define	IFT_IEEE80212		55	/* 100BaseVG */
#define	IFT_FIBRE_CHANNEL	56	/* Fibre Channel */
#define	IFT_HIPPIINTERFACES	57	/* HIPPI interfaces */
#define	IFT_FRAMERELAYINTERCONNECT 58	/* Interconnet over FR */
#define	IFT_AFLANE8023		59	/* ATM Emulated LAN for 802.3 */
#define	IFT_AFLANE8025		60	/* ATM Emulated LAN for 802.5 */
#define	IFT_CCTEMUL		61	/* ATM Emulated circuit */
#define	IFT_FASTETHER		62	/* Fast Ethernet (100BaseT) */
#define	IFT_ISDN		63	/* ISDN and X.25 */
#define	IFT_V11			64	/* CCITT V.11/X.21 */
#define	IFT_V36			65	/* CCITT V.36 */
#define	IFT_G703_64K		66	/* CCITT G703 at 64Kbps */
#define	IFT_G703_2MB		67	/* CCITT G703 at 2Mbps */
#define	IFT_QLLC		68	/* SNA QLLC */
#define	IFT_FASTETHERFX		69	/* Fast Ethernet (100BaseFX) */
#define	IFT_CHANNEL		70	/* channel */
#define	IFT_IEEE80211		71	/* radio spread spectrum */
#define	IFT_IBM370PARCHAN	72	/* IBM System 360/370 OEMI Channel */
#define	IFT_ESCON		73	/* IBM Enterprise Systems Connection */
#define	IFT_DLSW		74	/* Data Link Switching */
#define	IFT_ISDNS		75	/* ISDN S/T interface */
#define	IFT_ISDNU		76	/* ISDN U interface */
#define	IFT_LAPD		77	/* Link Access Protocol D */
#define	IFT_IP_SWITCH		78	/* IP Switching Objects */
#define	IFT_RSRB		79	/* Remote Source Route Bridging */
#define	IFT_ATM_LOGICAL		80	/* ATM Logical Port */
#define	IFT_DS0			81	/* Digital Signal Level 0 */
#define	IFT_DS0BUNDLE		82	/* group of ds0s on the same ds1 */
#define	IFT_BSC			83	/* Bisynchronous Protocol */
#define	IFT_ASYNC		84	/* Asynchronous Protocol */
#define	IFT_CNR			85	/* Combat Net Radio */
#define	IFT_ISO88025DTR		86	/* ISO 802.5r DTR */
#define	IFT_EPLRS		87	/* Enhanced  Pos Loc Report Sys */
#define	IFT_ARAP		88	/* Appletalk Remote Access Protocol */
#define	IFT_PROPCNLS		89	/* Proprietary Connectionless Proto. */
#define	IFT_HOSTPAD		90	/* CCITT-ITU X.29 PAD Protocol */
#define	IFT_TERMPAD		91	/* CCITT-ITU X.3 PAD Facility */
#define	IFT_FRAMERELAYMPI	92	/* Multiproto Interconnect over FR */
#define	IFT_X213		93	/* CCITT-ITU X213 */
#define	IFT_ADSL		94	/* Asymmetric Digital Subscriber Loop */
#define	IFT_RADSL		95	/* Rate-Adapt Digital Subscriber Loop */
#define	IFT_SDSL		96	/* Symmetric Digital Subscriber Loop */
#define	IFT_VDSL		97	/* Very HSpeed Digital Subscrib. Loop */
#define	IFT_ISO88025CRFPINT	98	/* ISO 802.5 CRFP */
#define	IFT_MYRINET		99	/* Myricom Myrinet */
#define	IFT_VOICEEM		100	/* Voice recEive and transMit (E&M) */
#define	IFT_VOICEFXO		101	/* Voice Foreign Exchange Office */
#define	IFT_VOICEFXS		102	/* Voice Foreign Exchange Station */
#define	IFT_VOICEENCAP		103	/* Voice encapsulation */
#define	IFT_VOICEOVERIP		104	/* Voice over IP encapsulation */
#define	IFT_ATMDXI		105	/* ATM DXI */
#define	IFT_ATMFUNI		106	/* ATM FUNI */
#define	IFT_ATMIMA		107	/* ATM IMA */
#define	IFT_PPPMULTILINKBUNDLE	108	/* PPP Multilink Bundle */
#define	IFT_IPOVERCDLC		109	/* IBM ipOverCdlc */
#define	IFT_IPOVERCLAW		110	/* IBM Common Link Access to Workstn */
#define	IFT_STACKTOSTACK	111	/* IBM stackToStack */
#define	IFT_VIRTUALIPADDRESS	112	/* IBM VIPA */
#define	IFT_MPC			113	/* IBM multi-protocol channel support */
#define	IFT_IPOVERATM		114	/* IBM ipOverAtm */
#define	IFT_ISO88025FIBER	115	/* ISO 802.5j Fiber Token Ring */
#define	IFT_TDLC		116	/* IBM twinaxial data link control */
#define	IFT_GIGABITETHERNET	117	/* Gigabit Ethernet */
#define	IFT_HDLC		118	/* HDLC */
#define	IFT_LAPF		119	/* LAP F */
#define	IFT_V37			120	/* V.37 */
#define	IFT_X25MLP		121	/* Multi-Link Protocol */
#define	IFT_X25HUNTGROUP	122	/* X25 Hunt Group */
#define	IFT_TRANSPHDLC		123	/* Transp HDLC */
#define	IFT_INTERLEAVE		124	/* Interleave channel */
#define	IFT_FAST		125	/* Fast channel */
#define	IFT_IP			126	/* IP (for APPN HPR in IP networks) */
#define	IFT_DOCSCABLEMACLAYER	127	/* CATV Mac Layer */
#define	IFT_DOCSCABLEDOWNSTREAM	128	/* CATV Downstream interface */
#define	IFT_DOCSCABLEUPSTREAM	129	/* CATV Upstream interface */
#define	IFT_A12MPPSWITCH	130	/* Avalon Parallel Processor */
#define	IFT_TUNNEL		131	/* Encapsulation interface */
#define	IFT_COFFEE		132	/* coffee pot */
#define	IFT_CES			133	/* Circiut Emulation Service */
#define	IFT_ATMSUBINTERFACE	134	/* ATM Sub Interface */
#define	IFT_L2VLAN		135	/* Layer 2 Virtual LAN using 802.1Q */
#define	IFT_L3IPVLAN		136	/* Layer 3 Virtual LAN - IP Protocol */
#define	IFT_L3IPXVLAN		137	/* Layer 3 Virtual LAN - IPX Prot. */
#define	IFT_DIGITALPOWERLINE	138	/* IP over Power Lines */
#define	IFT_MEDIAMAILOVERIP	139	/* Multimedia Mail over IP */
#define	IFT_DTM			140	/* Dynamic synchronous Transfer Mode */
#define	IFT_DCN			141	/* Data Communications Network */
#define	IFT_IPFORWARD		142	/* IP Forwarding Interface */
#define	IFT_MSDSL		143	/* Multi-rate Symmetric DSL */
#define	IFT_IEEE1394		144	/* IEEE1394 High Perf Serial Bus */
#define	IFT_IFGSN		145	/* HIPPI-6400 */
#define	IFT_DVBRCCMACLAYER	146	/* DVB-RCC MAC Layer */
#define	IFT_DVBRCCDOWNSTREAM	147	/* DVB-RCC Downstream Channel */
#define	IFT_DVBRCCUPSTREAM	148	/* DVB-RCC Upstream Channel */
#define	IFT_ATMVIRTUAL		149	/* ATM Virtual Interface */
#define	IFT_MPLSTUNNEL		150	/* MPLS Tunnel Virtual Interface */
#define	IFT_SRP			151	/* Spatial Reuse Protocol */
#define	IFT_VOICEOVERATM	152	/* Voice over ATM */
#define	IFT_VOICEOVERFRAMERELAY	153	/* Voice Over Frame Relay */
#define	IFT_IDSL		154	/* Digital Subscriber Loop over ISDN */
#define	IFT_COMPOSITELINK	155	/* Avici Composite Link Interface */
#define	IFT_SS7SIGLINK		156	/* SS7 Signaling Link */
#define	IFT_PROPWIRELESSP2P	157	/* Prop. P2P wireless interface */
#define	IFT_FRFORWARD		158	/* Frame forward Interface */
#define	IFT_RFC1483		159	/* Multiprotocol over ATM AAL5 */
#define	IFT_USB			160	/* USB Interface */
#define	IFT_IEEE8023ADLAG	161	/* IEEE 802.3ad Link Aggregate */
#define IFT_BGPPOLICYACCOUNTING	162	/* BGP Policy Accounting */
#define IFT_FRF16MFRBUNDLE	163	/* FRF.16 Multilik Frame Relay */
#define IFT_H323GATEKEEPER	164	/* H323 Gatekeeper */
#define IFT_H323PROXY		165	/* H323 Voice and Video Proxy */
#define IFT_MPLS		166	/* MPLS */
#define IFT_MFSIGLINK		167	/* Multi-frequency signaling link */
#define IFT_HDSL2		168	/* High Bit-Rate DSL, 2nd gen. */
#define IFT_SHDSL		169	/* Multirate HDSL2 */
#define IFT_DS1FDL		170	/* Facility Data Link (4Kbps) on a DS1*/
#define IFT_POS			171	/* Packet over SONET/SDH Interface */
#define IFT_DVBASILN		172	/* DVB-ASI Input */
#define IFT_DVBASIOUT		173	/* DVB-ASI Output */
#define IFT_PLC			174	/* Power Line Communications */
#define IFT_NFAS		175	/* Non-Facility Associated Signaling */
#define IFT_TR008		176	/* TROO8 */
#define IFT_GR303RDT		177	/* Remote Digital Terminal */
#define IFT_GR303IDT		178	/* Integrated Digital Terminal */
#define IFT_ISUP		179	/* ISUP */
#define IFT_PROPDOCSWIRELESSMACLAYEr	180	/* prop/Wireless MAC Layer */
#define IFT_PROPDOCSWIRELESSDOWNSTREAM	181	/* prop/Wireless Downstream */
#define IFT_PROPDOCSWIRELESSUPSTREAM	182	/* prop/Wireless Upstream */
#define IFT_HIPERLAN2		183	/* HIPERLAN Type 2 Radio Interface */

/* Before adding new types, see the comments at top of the file */
#define	IFT_AIF			200	/* XXX Aggregating interface */

/* private usage... how should we define these? */
#define	IFT_GIF		0xf0
#define	IFT_DUMMY	0xf1
#define IFT_PVC		0xf2
#define IFT_FAITH	0xf3
#define	IFT_STF		0xf4

#endif /* !_IF_TYPES_H_ */
