/*
 * Copyright 1998 Massachusetts Institute of Technology
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that both the above copyright notice and this
 * permission notice appear in all copies, that both the above
 * copyright notice and this permission notice appear in all
 * supporting documentation, and that the name of M.I.T. not be used
 * in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  M.I.T. makes
 * no representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.
 * 
 * THIS SOFTWARE IS PROVIDED BY M.I.T. ``AS IS''.  M.I.T. DISCLAIMS
 * ALL EXPRESS OR IMPLIED WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT
 * SHALL M.I.T. BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * FreeBSD: src/sys/net/if_vlan_var.h,v 1.3 1999/08/28 00:48:24 peter Exp 
 *
 * Ported to BSD/OS by Geert Jan de Groot
 * BSDI if_vlan.h,v 2.5 2000/06/18 03:36:36 dab Exp
 */

#ifndef _NET_IF_VLAN_H_
#define	_NET_IF_VLAN_H_	

#include <net/if_ethernet.h>

struct	ether_8021q_header {
	u_char	evlq_dhost[ETHER_ADDR_LEN];
	u_char	evlq_shost[ETHER_ADDR_LEN];
	u_int16_t evlq_encap_proto;
	u_int16_t evlq_tci;
	u_int16_t evlq_proto;
};

#define	EVLQ_VIDOFTCI(tci)		((tci) & 0xfff)
#define	EVLQ_PRIOFTCI(tci)		(((tci) >> 13) & 7)
#define	EVLQ_CFIOFTCI(tci)		(((tci) >> 12) & 1)
#define	EVLQ_TCI(prio, cfi, vid)	(((prio) & 7) << 13 | \
				    	    ((cfi) & 1) << 12 | \
					    (vid) & 0xfff)
#define	EVLQ_VID_NULL			0	/* Null VLAN */
#define	EVLQ_VID_DEF			1	/* Default VLAN */
#define	EVLQ_VID_RESV			0xfff	/* Reserved */
#define	EVLQ_ENCAPLEN			4	/* minimum length in octets of encapsulation */

#define	VQI_ALLOC_MIN	256		/* Minimum number of entries in the index */

/*
 * Lookup a vlan given it's parent's ifp and VLAN ID
 */
#define	VLAN_8021Q_LOOKUP(ifp, vid) \
	((((struct arpcom *)(ifp))->ac_8021q_vlans == NULL || \
	    (vid) >= ((struct arpcom *)(ifp))->ac_8021q_maxalloc) ? NULL : \
	    ((struct arpcom *)(ifp))->ac_8021q_vlans[(vid)])

/*
 * Configuration structure for SIOCSETVLAN and SIOCGETVLAN ioctls.
 */
struct	vlanreq {
	char    vlr_name[IFNAMSIZ];
	char	vlr_parent[IFNAMSIZ];
	u_int 	vlr_id;			/* Vlan ID */
};

#define	SIOCSETVLAN	_IOW('i', 210, struct vlanreq)
#define	SIOCGETVLAN	_IOWR('i', 211, struct vlanreq)

#ifdef KERNEL
/* shared with if_ethersubr.c: */
extern u_int 	vlan_8021q_proto;
extern void	vlan_media_change(struct ifnet *);
extern struct ifnet *vlan_aif_find(struct ifnet *, u_int);

#endif

#endif /* _NET_IF_VLAN_H_ */
