/*
 * Copyright 1998 Massachusetts Institute of Technology
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that both the above copyright notice and this
 * permission notice appear in all copies, that both the above
 * copyright notice and this permission notice appear in all
 * supporting documentation, and that the name of M.I.T. not be used
 * in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  M.I.T. makes
 * no representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.
 * 
 * THIS SOFTWARE IS PROVIDED BY M.I.T. ``AS IS''.  M.I.T. DISCLAIMS
 * ALL EXPRESS OR IMPLIED WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT
 * SHALL M.I.T. BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * FreeBSD: src/sys/net/if_vlan_var.h,v 1.3 1999/08/28 00:48:24 peter Exp 
 *
 * Ported to BSD/OS by Geert Jan de Groot
 * BSDI if_vlan_var.h,v 2.2 2000/02/18 02:14:23 jch Exp
*/

#ifndef _NET_IF_VLAN_VAR_H_
#define	_NET_IF_VLAN_VAR_H_

struct vlan_mc_entry {
	struct ifreq vm_ifr;
	u_char vm_addrlo[ETHER_ADDR_LEN];
	u_char vm_addrhi[ETHER_ADDR_LEN];
	u_int vm_refcount;
	struct vlan_mc_entry *vm_next;
};

struct	ifv_softc {
	struct arpcom ifv_ac;	/* make this an interface */
	struct ifnet *ifv_p;	/* parent interface of this vlan */
	struct vlan_mc_entry *ifv_mchead;
	u_int ifv_saveflags;	/* saved flags */
	u_int ifv_vid;		/* VLAN ID */
};
#define	ifv_if	ifv_ac.ac_if

#endif /* _NET_IF_VLAN_VAR_H_ */
