/*
 *
 * ===================================
 * HARP  |  Host ATM Research Platform
 * ===================================
 *
 *
 * Copyright (c) 1994-1998, Network Computing Services, Inc.
 * All rights reserved.
 *
 *	@(#) kern_include.h,v 1.7 1998/07/23 21:44:40 root Exp
 *
 */

/*
 * Core ATM Services
 * -----------------
 *
 * Common kernel module includes
 *
 */

#ifndef _NETATM_KERN_INCLUDE_H
#define	_NETATM_KERN_INCLUDE_H

/*
 * Note that we're compiling kernel code
 */
#define	ATM_KERNEL

/*
 * System configuration information
 */
#include <netatm/config.h>

#ifdef _HAVE_PARAM_H
#include <sys/param.h>
#endif

/*
 * Compiler-dependent stuff
 */
#if (defined(BSD) && (BSD >= 199103))
#include <sys/cdefs.h>

#else	/* !(defined(BSD) && (BSD >= 199103)) */
#if defined(__STDC__)
#define	__P(proto)	proto		/* Function prototypes */

#else	/* !defined(__STDC__) */
#define	const
#define	volatile
#define	__P(proto)	()		/* Function prototypes */
#endif	/*  !defined(__STDC__) */
#endif	/* !(defined(BSD) && (BSD >= 199103)) */

/*
 * System support
 */
#include <sys/systm.h>
#include <sys/types.h>
#include <sys/errno.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <sys/kernel.h>
#include <sys/conf.h>
#include <sys/domain.h>
#include <sys/protosw.h>
#include <sys/socket.h>
#include <sys/socketvar.h>
#include <sys/syslog.h>

#ifdef sun
#include <machine/cpu.h>
#include <machine/mmu.h>
#include <machine/psl.h>
#include <sun/openprom.h>
#include <sun/vddrv.h>
#include <sundev/mbvar.h>
#endif

#ifdef __FreeBSD__
#include <machine/clock.h>
#include <machine/spl.h>
#include <sys/exec.h>
#include <sys/sysent.h>
#include <sys/lkm.h>
#include <vm/vm.h>
#include <vm/lock.h>
#include <vm/pmap.h>
#endif

#ifdef __bsdi__
#include <sys/device.h>
#include <machine/autoconf.h>
#include <machine/cpu.h>
#include <vm/vm.h>
#include <vm/pmap.h>
#include <sparc/sparc/cache.h>
#include <sparc/sbus/sbusvar.h>
#endif

/*
 * Networking support
 */
#include <net/if.h>
#if (defined(BSD) && (BSD >= 199103))
#include <net/if_types.h>
#include <net/if_dl.h>
#endif
#include <net/netisr.h>
#include <net/route.h>
#include <netinet/in.h>
#include <netinet/in_var.h>
#include <netinet/if_ether.h>

#ifdef	_HAVE_BPF
#include <net/bpf.h>
#include <net/bpfdesc.h>
#endif

/*
 * Porting fluff
 */
#include <netatm/port.h>

/*
 * ATM core services
 */
#include <netatm/queue.h>
#include <netatm/atm.h>
#include <netatm/atm_sys.h>
#include <netatm/atm_sap.h>
#include <netatm/atm_cm.h>
#include <netatm/atm_if.h>
#include <netatm/atm_vc.h>
#include <netatm/atm_ioctl.h>
#include <netatm/atm_sigmgr.h>
#include <netatm/atm_stack.h>
#include <netatm/atm_pcb.h>
#include <netatm/atm_var.h>

#endif	/* _NETATM_KERN_INCLUDE_H */
