/*
 *
 * ===================================
 * HARP  |  Host ATM Research Platform
 * ===================================
 *
 *
 * Copyright (c) 1994-1998, Network Computing Services, Inc.
 * All rights reserved.
 *
 *	@(#) sigpvc_var.h,v 1.5 1998/02/19 20:16:28 mks Exp
 *
 */

/*
 * PVC-only Signalling Manager
 * ---------------------------
 *
 * Protocol control blocks
 *
 */

#ifndef _SIGPVC_SIGPVC_VAR_H
#define _SIGPVC_SIGPVC_VAR_H

#ifdef ATM_KERNEL
/*
 * Structure containing state information for each SigPVC protocol instance.
 * There will be one instance for each ATM device interface using the SigPVC
 * signalling manager.
 */
struct	sigpvc {
	struct siginst	pv_inst;	/* Common header */
};
#define	pv_next		pv_inst.si_next
#define	pv_pif		pv_inst.si_pif
#define	pv_addr		pv_inst.si_addr
#define	pv_vccq		pv_inst.si_vccq
#define	pv_state	pv_inst.si_state
#endif	/* ATM_KERNEL */

/*
 * SigPVC Protocol States
 */
#define	SIGPVC_ACTIVE	1		/* Active */
#define	SIGPVC_DETACH	2		/* Detach in progress */


#ifdef ATM_KERNEL
/*
 * SigPVC Virtual Channel Connection control block.  All information regarding
 * the state of a SigPVC controlled VCC will be recorded here.  There will be
 * one SigPVC VCC control block for each SigPVC-controlled VCC.
 */
struct sigpvc_vccb {
	struct vccb	vcp_hdr;	/* Generic vccb */
};
#endif	/* ATM_KERNEL */

/*
 * SigPVC VCC Signalling Protocol States
 */
#define	VCCS_NULL	0		/* No state */
#define	VCCS_ACTIVE	1		/* Active */
#define	VCCS_FREE	2		/* Waiting for user to free resources */


#ifdef ATM_KERNEL
/*
 * Global function declarations
 */
	/* sigpvc_if.c */

	/* sigpvc_subr.c */
int		sigpvc_create_pvc __P((struct sigpvc *, Atm_connvc *, int *));
void		sigpvc_close_vcc __P((struct vccb *));

#endif	/* ATM_KERNEL */

#endif	/* _SIGPVC_SIGPVC_VAR_H */
