/*
 *
 * ===================================
 * HARP  |  Host ATM Research Platform
 * ===================================
 *
 *
 * Copyright (c) 1994-1998, Network Computing Services, Inc.
 * All rights reserved.
 *
 *	@(#) unisig_decode.h,v 1.5 1998/08/26 23:29:21 mks Exp
 *
 */

/*
 * ATM Forum UNI 3.0/3.1 Signalling Manager
 * ----------------------------------------
 *
 * Message formats
 *
 */

#ifndef _UNI_SIG_DECODE_H
#define _UNI_SIG_DECODE_H


/*
 * Values specifying which IEs are required in messages
 */
#define	IE_NA	0
#define	IE_MAND	1
#define	IE_OPT	2

/*
 * Structure for information element decoding information
 */
struct ie_ent {
	u_char		ident;		/* IE identifier */
	int		min_len;	/* Min. length */
	int		max_len;	/* Max. length */
	int		p_idx;		/* IE pointer index in msg */
	int		(*decode)	/* Decoding function */
				__P((struct usfmt *, struct ie_generic *));
};

/*
 * Macro to give the offset of a field in a generic IE structure
 */
#define	IE_OFFSET(f) \
	((int)&((struct ie_generic *) 0)->f)

/*
 * Macro to give the size of a field in a generic IE structure
 */
#define IE_FSIZE(f) \
	(sizeof(((struct ie_generic *) 0)->f))

#define IE_OFF_SIZE(f)   IE_OFFSET(f),IE_FSIZE(f)


/*
 * Structure to define a field-driven decoding table (for AAL
 * parameters and ATM user cell rate IEs)
 */
struct ie_decode_tbl {
	u_char	ident;
	int	len;
	int	f_offs;
	int	f_size;
};

#endif /* _UNI_SIG_DECODE_H */
