/*
 *
 * ===================================
 * HARP  |  Host ATM Research Platform
 * ===================================
 *
 *
 * Copyright (c) 1994-1998, Network Computing Services, Inc.
 * All rights reserved.
 *
 *	@(#) unisig_mbuf.h,v 1.5 1998/08/26 23:29:22 mks Exp
 *
 */

/*
 * ATM Forum UNI 3.0/3.1 Signalling Manager
 * ----------------------------------------
 *
 * Message buffer formats
 *
 */

#ifndef _UNI_SIG_MBUF_H
#define _UNI_SIG_MBUF_H


/*
 * Structure for message encoding/decoding information.
 */
struct usfmt {
	KBuffer		*usf_m_addr;	/* Current buffer */
	KBuffer		*usf_m_base;	/* First buffer in chain */
	int		usf_loc;	/* Offset in current buffer */
	int		usf_op;		/* Operation (see below) */
	struct unisig	*usf_sig;	/* UNI signalling instance */
};

#define	USF_ENCODE	1
#define	USF_DECODE	2

#define	USF_MIN_ALLOC	100		/* Minimum encoding buffer size */

#endif	/* _UNI_SIG_MBUF_H */
