/*
 *
 * ===================================
 * HARP  |  Host ATM Research Platform
 * ===================================
 *
 *
 * Copyright (c) 1994-1998, Network Computing Services, Inc.
 * All rights reserved.
 *
 *	@(#) user_include.h,v 1.4 1998/02/19 20:00:42 mks Exp
 *
 */

/*
 * Core ATM Services
 * -----------------
 *
 * Common user-space module includes
 *
 */

#ifndef _NETATM_USER_INCLUDE_H
#define	_NETATM_USER_INCLUDE_H

/*
 * System configuration information
 */
#include <netatm/config.h>

#ifdef _HAVE_PARAM_H
#include <sys/param.h>
#endif

/*
 * Compiler-dependent stuff
 */
#if (defined(BSD) && (BSD >= 199103))
#include <sys/cdefs.h>

#else	/* !(defined(BSD) && (BSD >= 199103)) */
#if defined(__STDC__)
#define	__P(proto)	proto		/* Function prototypes */

#else	/* !defined(__STDC__) */
#define	const
#define	volatile
#define	__P(proto)	()		/* Function prototypes */
#endif	/*  !defined(__STDC__) */
#endif	/* !(defined(BSD) && (BSD >= 199103)) */

/*
 * System support
 */
#include <sys/types.h>
#include <sys/ioccom.h>
#include <sys/time.h>
#include <sys/socket.h>

/*
 * Networking support
 */
#include <net/if.h>
#include <netinet/in.h>

/*
 * Porting fluff
 */
#include <netatm/port.h>

/*
 * ATM core services
 */
#include <netatm/queue.h>
#include <netatm/atm.h>
#include <netatm/atm_sys.h>
#include <netatm/atm_sap.h>
#include <netatm/atm_cm.h>
#include <netatm/atm_if.h>
#include <netatm/atm_vc.h>
#include <netatm/atm_ioctl.h>
#include <netatm/atm_sigmgr.h>
#include <netatm/atm_stack.h>
#include <netatm/atm_var.h>

#endif	/* _NETATM_USER_INCLUDE_H */
