/*	BSDI in.h,v 2.31.2.2 2001/04/24 00:11:39 peer Exp */

/*
 * Copyright (c) 1982, 1986, 1990, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)in.h	8.3 (Berkeley) 1/3/94
 */

#ifndef _NETINET_IN_H_
#define	_NETINET_IN_H_

#include <sys/types.h>		/* XXX for defined-size int types */
#include <sys/sockettypes.h>

/*
 * Constants and structures defined by the internet system,
 * Per RFC 790, September 1981, and numerous additions.
 */

/*
 * Protocols
 */
#define	IPPROTO_IP		0		/* dummy for IP */
#define	IPPROTO_HOPOPTS		0		/* IPv6 Hop-by-Hop Option */
#define	IPPROTO_ICMP		1		/* control message protocol */
#define	IPPROTO_IGMP		2		/* group mgmt protocol */
#define	IPPROTO_GGP		3		/* gateway^2 (deprecated) */
#define	IPPROTO_IPIP		4		/* IP inside IP */
#define	IPPROTO_IPV4		4		/* IP inside IP */
#define	IPPROTO_TCP		6		/* tcp */
#define	IPPROTO_EGP		8		/* exterior gateway protocol */
#define	IPPROTO_PUP		12		/* pup */
#define	IPPROTO_UDP		17		/* user datagram protocol */
#define	IPPROTO_IDP		22		/* xns idp */
#define	IPPROTO_TP		29		/* tp-4 w/ class negotiation */
#define	IPPROTO_IPV6		41		/* IPv6 in IP */
#define	IPPROTO_ROUTING		43		/* Routing Header for IPv6 */
#define	IPPROTO_FRAGMENT	44		/* Fragment Header for IPv6 */
#define	IPPROTO_RSVP		46		/* Reservation protocol */
#define	IPPROTO_ESP		50		/* IPv6 Encap Security Payld. */
#define	IPPROTO_AH		51		/* IPv6 Authentication Header */
#define	IPPROTO_ICMPV6		58		/* ICMP for IPv6 */
#define	IPPROTO_NONE		59		/* No Next Header for IPv6 */
#define	IPPROTO_DSTOPTS		60		/* Dest. Options for IPv6 */
#define	IPPROTO_EON		80		/* ISO cnlp */
#define	IPPROTO_ENCAP		98		/* Encapsulation Header */
#define	IPPROTO_PIM		103		/* Protocol indep. multicast */
#define	IPPROTO_IPCOMP		108		/* IP Payload Comp. Protocol */
#define IPPROTO_SCTP		132		/* SCTP (RFC2960) */

#define	IPPROTO_RAW		255		/* raw IP packet */
#define	IPPROTO_MAX		256

/* last return value of *_input(), meaning "all job for this pkt is done".  */
#define	IPPROTO_DONE		257

#ifdef KERNEL
/* backward-compatibility definitions for NRL-local symbols */
#define	IPPROTO_ICMPV4		IPPROTO_ICMP
#define	IPPROTO_HOPOPT		IPPROTO_HOPOPTS
#define	IPPROTO_HOP		IPPROTO_HOPOPTS
#define IPPROTO_IPV6_ROUTE	IPPROTO_ROUTING	
#define	IPPROTO_IPV6_FRAG	IPPROTO_FRAGMENT
#define	IPPROTO_IPV6_NONXT	IPPROTO_NONE
#define	IPPROTO_IPV6_OPTS	IPPROTO_DSTOPTS
#define	IPPROTO_DST		IPPROTO_DSTOPTS
#endif

#ifndef _POSIX_SOURCE
/*
 * "Protocols" defined below are pseudo protocols and not used by IP
 * (IP has an 8 bit protocol field)
 */

/*
 * IP pseudo protocols
 */
#define	IPFW_PROTO		256		/* IPFW logging socket */
#define	IPFW_FLOW_PROTO		257		/* IPFW flow logging socket */
#endif /* _POSIX_SOURCE */

/*
 * Local port number conventions:
 * Ports < IPPORT_RESERVED are reserved for
 * privileged processes (e.g. root).
 * Ports >= IPPORT_RESERVED && < IPPORT_DYNAMIC
 * are reserved for servers, not necessarily privileged.
 * Ports >= IPPORT_DYNAMIC are available for
 * dynamic port assignment.
 */
#define	IPPORT_RESERVED		1024
#define	IPPORT_DYNAMIC		49152
#define	IPPORT_DYNAMIC_LAST	65535

/*
 * Internet address (a structure for historical reasons)
 */
struct in_addr {
	u_int32_t s_addr;
};

typedef	u_int32m_t in_addr_t;
typedef	u_int16m_t in_port_t;

/*
 * Definitions of bits in internet address integers.
 * On subnets, the decomposition of addresses to host and net parts
 * is done according to subnet mask, not the masks here.
 */
#define	IN_CLASSA(i)		(((int32_t)(i) & 0x80000000) == 0)
#define	IN_CLASSA_NET		0xff000000
#define	IN_CLASSA_NSHIFT	24
#define	IN_CLASSA_HOST		0x00ffffff
#define	IN_CLASSA_MAX		128

#define	IN_CLASSB(i)		(((int32_t)(i) & 0xc0000000) == 0x80000000)
#define	IN_CLASSB_NET		0xffff0000
#define	IN_CLASSB_NSHIFT	16
#define	IN_CLASSB_HOST		0x0000ffff
#define	IN_CLASSB_MAX		65536

#define	IN_CLASSC(i)		(((int32_t)(i) & 0xe0000000) == 0xc0000000)
#define	IN_CLASSC_NET		0xffffff00
#define	IN_CLASSC_NSHIFT	8
#define	IN_CLASSC_HOST		0x000000ff

#define	IN_CLASSD(i)		(((int32_t)(i) & 0xf0000000) == 0xe0000000)
#define	IN_CLASSD_NET		0xf0000000	/* These ones aren't really */
#define	IN_CLASSD_NSHIFT	28		/* net and host fields, but */
#define	IN_CLASSD_HOST		0x0fffffff	/* routing needn't know.    */
#define	IN_MULTICAST(i)		IN_CLASSD(i)

#define	IN_EXPERIMENTAL(i)	(((int32_t)(i) & 0xf0000000) == 0xf0000000)
#define	IN_BADCLASS(i)		(((int32_t)(i) & 0xf0000000) == 0xf0000000)

#define	INADDR_ANY		(u_int32_t)0x00000000
#define	INADDR_BROADCAST	(u_int32_t)0xffffffff	/* must be masked */
#ifndef KERNEL
#define	INADDR_NONE		0xffffffff		/* -1 return */
#endif

#define	INADDR_UNSPEC_GROUP	(u_int32_t)0xe0000000	/* 224.0.0.0 */
#define	INADDR_ALLHOSTS_GROUP	(u_int32_t)0xe0000001	/* 224.0.0.1 */
#define	INADDR_MAX_LOCAL_GROUP	(u_int32_t)0xe00000ff	/* 224.0.0.255 */

#define	IN_LOOPBACKNET		127			/* official! */

/*
 * Socket address, internet style.
 */
struct sockaddr_in {
	u_char		sin_len;
	sa_family_t	sin_family;
	u_short		sin_port;
	struct in_addr	sin_addr;
	char		sin_zero[8];
};

__BEGIN_DECLS /* C++ doesn't permit member name / tag name collisions.  */
/*
 * Structure used to describe IP options.
 * Used to store options internally, to pass them to a process,
 * or to restore options retrieved earlier.
 * The ip_dst is used for the first-hop gateway when using a source route
 * (this gets put into the header proper).
 */
struct ip_opts {
	struct	in_addr ip_dst;		/* first hop, 0 w/o src rt */
	char	ip_opts[40];		/* actually variable in size */
};
__END_DECLS

/*
 * Options for use with [gs]etsockopt at the IPPROTO_IP level.
 * First word of comment is data type; bool is stored in int.
 */
#define	IP_OPTIONS		1    /* buf/ip_opts; set/get IP options */
#define	IP_HDRINCL		2    /* int; header is included with data */
#define	IP_TOS			3    /* int; IP type of service and preced. */
#define	IP_TTL			4    /* int; IP time to live */
#define	IP_RECVOPTS		5    /* bool; receive all IP opts w/dgram */
#define	IP_RECVRETOPTS		6    /* bool; receive IP opts for response */
#define	IP_RECVDSTADDR		7    /* bool; receive IP dst addr w/dgram */
#define	IP_RETOPTS		8    /* ip_opts; set/get IP options */
#define	IP_MULTICAST_IF		9    /* u_char; set/get IP multicast i/f  */
#define	IP_MULTICAST_TTL	10   /* u_char; set/get IP multicast ttl */
#define	IP_MULTICAST_LOOP	11   /* u_char; set/get IP multicast loopback */
#define	IP_ADD_MEMBERSHIP	12   /* ip_mreq; add an IP group membership */
#define	IP_DROP_MEMBERSHIP	13   /* ip_mreq; drop an IP group membership */
#define	IP_MULTICAST_VIF	14   /* set/get IP mcast vir. interface */
#define	IP_ONESBCAST		15   /* Use all ones broadcast */
#if 1 /*IPSEC*/
#define IP_IPSEC_POLICY		16   /* struct; get/set security policy */
#endif

#ifndef _POSIX_SOURCE
/*
 * Options for use with [gs]etsockopt at the IPPROTO_IPV6 level.
 * First word of comment is data type; bool is stored in u_int.
 */


/*
 * Defaults and limits for options
 */
#define	IP_DEFAULT_MULTICAST_TTL  1	/* normally limit m'casts to 1 hop  */
#define	IP_DEFAULT_MULTICAST_LOOP 1	/* normally hear sends if a member  */
#define	IP_MAX_MEMBERSHIPS	20	/* per socket; must fit in one mbuf */

/*
 * Argument structure for IP_ADD_MEMBERSHIP and IP_DROP_MEMBERSHIP.
 */
struct ip_mreq {
	struct	in_addr imr_multiaddr;	/* IP multicast address of group */
	struct	in_addr imr_interface;	/* local IP address of interface */
};

/*
 * Definitions for inet sysctl operations.
 *
 * Third level is protocol number.
 * Fourth level is desired variable within that protocol.
 */
#define	IPPROTO_MAXID	(IPPROTO_ICMPV6 + 1)	/* don't list to IPPROTO_MAX */

#define	CTL_IPPROTO_NAMES { \
	{ "ip", CTLTYPE_NODE }, \
	{ "icmp", CTLTYPE_NODE }, \
	{ "igmp", CTLTYPE_NODE }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ "tcp", CTLTYPE_NODE }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ "udp", CTLTYPE_NODE }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ "idp", CTLTYPE_NODE }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ "ip6", CTLTYPE_NODE }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ "esp", CTLTYPE_NODE }, \
	{ "ah", CTLTYPE_NODE }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ "icmp6", CTLTYPE_NODE }, \
}

/*
 * Names for IP sysctl objects
 */
#define	IPCTL_FORWARDING	1	/* act as router */
#define	IPCTL_SENDREDIRECTS	2	/* may send redirects when forwarding */
#define	IPCTL_DEFTTL		3	/* default TTL */
#ifdef notyet
#define	IPCTL_DEFMTU		4	/* default MTU */
#endif
#define	IPCTL_FORWSRCRT		5	/* forward source-routed dgrams */
#define	IPCTL_STATS		6	/* stats */
#define	IPCTL_MRTSTATS		7	/* multicast forwarding stats */
#define	IPCTL_MRTPROTO		8	/* multicast routing protocol */
#define	IPCTL_MAXFRAGPACKETS	9	/* max packets reassembly queue */
#define	IPCTL_SOURCECHECK	10	/* verify source route and intf */
#define	IPCTL_SOURCECHECK_LOGINT	11	/* minimume logging interval */
#define	IPCTL_IPFW		12	/* IP Filters */
#define	IPCTL_DORFC1858		13	/* use RFC 1858 filtering */
#define	IPCTL_MRTTABLE		14	/* multicast routing table */
#define	IPCTL_VIFTABLE		15	/* multicast virtual interface table */
#define	IPCTL_RATEFILTER	16	/* IP Rate Filters */
#define	IPCTL_MAXID		17

#define	IPCTL_NAMES { \
	{ 0, 0 }, \
	{ "forwarding", CTLTYPE_INT }, \
	{ "redirect", CTLTYPE_INT }, \
	{ "ttl", CTLTYPE_INT }, \
	{ "mtu", CTLTYPE_INT }, \
	{ "forwsrcrt", CTLTYPE_INT }, \
	{ "stats", CTLTYPE_STRUCT }, \
	{ "mrtstats", CTLTYPE_STRUCT }, \
	{ "mrtproto", CTLTYPE_INT }, \
	{ "maxfragpackets", CTLTYPE_INT }, \
	{ "sourcecheck", CTLTYPE_INT }, \
	{ "sourcecheck_logint", CTLTYPE_INT }, \
	{ "ipfw", CTLTYPE_NODE }, \
	{ "do_rfc1858", CTLTYPE_INT }, \
	{ "mrttable", CTLTYPE_STRUCT }, \
	{ "viftable", CTLTYPE_STRUCT }, \
	{ "ratefilter", CTLTYPE_NODE }, \
}

#define	IPCTL_VARS { \
	0, \
	&ipforwarding, \
	&ipsendredirects, \
	&ip_defttl, \
	0, /* &ip_mtu */ \
	&ipforward_srcrt, \
	0, \
	0, \
	0, \
	&ip_maxfragpackets, \
	&ip_sourcecheck, \
	&ip_sourcecheck_interval, \
	0, \
	&ip_do_rfc1858, \
	0, \
	0, \
	0 \
}

#define	IPIFCTL_GEN_MULTIADDRS	1	/* Multicast Group Membership */
#define	IPIFCTL_GEN_MAXID	2

#define	IPIFCTL_GEN_NAMES { \
	{ 0, 0 }, \
	{ "multiaddrs", CTLTYPE_STRUCT }, \
}

/* Structure used to report group membership via sysctl */
struct in_multiaddr {
	struct	in_multiaddr *ima_next;	/* Pointer to next in chain */
	struct	in_addr ima_group;	/* Multicast address */
	u_short	ima_refcount;		/* # membership claims by sockets */
	u_short ima_state;		/* state of the membership */
	u_int	ima_timer;		/* IGMP membership report timer */
};
#endif /* _POSIX_SOURCE */

/* INET6 stuff */
#define __KAME_NETINET_IN_H_INCLUDED_
#include <netinet6/in6.h>
#undef __KAME_NETINET_IN_H_INCLUDED_

#ifdef KERNEL
struct ifnet;
struct mbuf;
int	 in_broadcast __P((struct in_addr, struct ifnet *));
int	 in_canforward __P((struct in_addr));
int	 in_mcksum __P((struct mbuf *, int, int, u_long));
#define	 in_cksum(m, len) in_mcksum(m, 0, len, 0)
int	 in_localaddr __P((struct in_addr));

#define	satosin(sa)	((struct sockaddr_in *)(sa))
#define	sintosa(sin)	((struct sockaddr *)(sin))
#define	ifatoia(ifa)	((struct in_ifaddr *)(ifa))
#endif

#ifndef _POSIX_SOURCE
#define INET_ADDRSTRLEN 16
#define INET6_ADDRSTRLEN 46
#endif /* _POSIX_SOURCE */

#ifdef NRL_COMPAT
#define	in6a_words	s6_u.s6u_addr32
#ifndef _POSIX_SOURCE
#define	IN6_IS_ADDR_EQUAL(addr1, addr2) IN6_ARE_ADDR_EQUAL(addr1, addr2)
#define	IN6_NODE_LOCAL		__IPV6_ADDR_SCOPE_NODELOCAL
#define	IN6_LINK_LOCAL		__IPV6_ADDR_SCOPE_LINKLOCAL
#define	IN6_SITE_LOCAL		__IPV6_ADDR_SCOPE_SITELOCAL
#define	IN6_ORG_LOCAL		__IPV6_ADDR_SCOPE_ORGLOCAL
#define	IN6_GLOBAL		__IPV6_ADDR_SCOPE_GLOBAL
#define	IN6_MSCOPE(addr)	__IPV6_ADDR_MC_SCOPE(a)
#define	IPV6_ADD_MEMBERSHIP	IPV6_JOIN_GROUP
#define	IPV6_DROP_MEMBERSHIP	IPV6_LEAVE_GROUP
#define	ICMPV6_FILTER		ICMP6_FILTER
#define	IPV6_RXHOPOPTS		IPV6_RECVHOPOPTS
#define	IPV6_RXDSTOPTS		IPV6_RECVDSTOPTS
#define	IPV6_RXSRCRT		IPV6_RECVRTHDR
#define	IPV6_RXINFO		IPV6_PKTINFO
#define	IPV6_TXINFO		IPV6_PKTINFO
#endif /* _POSIX_SOURCE */
#endif	/* NRL_COMPAT */

#endif /* _NETINET_IN_H_ */
