/*
 * Copyright (c) 1996, 1997 Berkeley Software Design, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that this notice is retained,
 * the conditions in the following notices are met, and terms applying
 * to contributors in the following notices also apply to Berkeley
 * Software Design, Inc.
 *
 *	BSDI in_proto.c,v 2.43.6.7 2001/07/10 23:07:00 dab Exp
 */

/*
 * in_proto.c  --  Protocol switch table for IP.
 *
 * Modifications to support IPv6 are copyright 1995
 * by Dan McDonald, Bao Phan, and Randall Atkinson, All Rights Reserved.
 * All Rights under this copyright have been assigned to NRL.
 *
 * See the file netinet6/COPYRIGHT.NRL for the licensing terms
 * on these modifications.
 */

/*
 * Copyright (c) 1982, 1986, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)in_proto.c	8.2 (Berkeley) 2/9/95
 */

#include <sys/param.h>
#include <sys/socket.h>
#include <sys/protosw.h>
#include <sys/domain.h>
#include <sys/mbuf.h>

#include <net/if.h>
#include <net/radix.h>
#include <net/route.h>

#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/ip_var.h>
#include <netinet/ip_icmp.h>
#include <netinet/in_pcb.h>
#include <netinet/igmp_var.h>
#include <netinet/tcp.h>
#include <netinet/tcp_fsm.h>
#include <netinet/tcp_seq.h>
#include <netinet/tcp_timer.h>
#include <netinet/tcp_var.h>
#include <netinet/tcpip.h>
#include <netinet/tcp_debug.h>
#include <netinet/udp.h>
#include <netinet/udp_var.h>
#include <netinet/ip_encap.h>

#ifdef INET6
#ifndef INET
#include <netinet/in.h>
#endif
#include <netinet6/ip6_var.h>
#endif

#ifdef IPSEC
#include <netinet6/ah.h>
#ifdef IPSEC_ESP
#include <netinet6/esp.h>
#endif
#include <netinet6/ipcomp.h>
#endif /* IPSEC */

#include "gif.h"
#if NGIF > 0
#include <netinet/in_gif.h>
#endif

#include "stf.h"
#if NSTF > 0
#include <net/if_stf.h>
#endif

/*
 * TCP/IP protocol family: IP, ICMP, UDP, TCP.
 */

#ifdef NSIP
void	idpip_input(), nsip_ctlinput();
#endif

#ifdef TPIP
void	tpip_input(), tpip_ctlinput(), tp_init(), tp_slowtimo(), tp_drain();
int	tp_ctloutput(), tp_usrreq();
#endif

#ifdef EON
void	eoninput(), eonctlinput(), eonprotoinit();
#endif /* EON */

#ifdef MROUTING
void	ipip_input();
#endif

#ifdef	IPFW
int	raw_usrreq(), ipfw_ctloutput();
#endif

#if 0
void ipv6_trans_ctlinput __P((int, struct sockaddr *, struct ip *, struct mbuf
 *));
int ipv6_sysctl __P((int *, u_int, void *, size_t *, void *, size_t));
int ipv6_icmp_sysctl __P((int *, u_int, void *, size_t *, void *, size_t));
#endif /* INET6 */

#if 0
void ipv4_input __P((struct mbuf *, int, struct in6_hdrindex *, int));
#endif

extern	struct domain inetdomain;

struct protosw inetsw[] = {
{ 0,		&inetdomain,	0,		0,
  0,		ip_output,	0,		0,
  0,
  ip_init,	0,		ip_slowtimo,	ip_drain,	ip_sysctl
},
{ SOCK_DGRAM,	&inetdomain,	IPPROTO_UDP,	PR_ATOMIC|PR_ADDR,
  udp_input,	0,		udp_ctlinput,	ip_ctloutput,
  udp_usrreq,
  udp_init,	0,		0,		0,		udp_sysctl
},
{ SOCK_STREAM,	&inetdomain,	IPPROTO_TCP,	PR_CONNREQUIRED|PR_WANTRCVD,
  tcp_input,	0,		tcp_ctlinput,	tcp_ctloutput,
  tcp_usrreq,
  tcp_init,	tcp_fasttimo,	tcp_slowtimo,	tcp_drain,	tcp_sysctl
},
{ SOCK_RAW,	&inetdomain,	IPPROTO_RAW,	PR_ATOMIC|PR_ADDR,
  rip_input,	rip_output,	rip_ctlinput,	rip_ctloutput,
  rip_usrreq,
  0,		0,		0,		0,
},
{ SOCK_RAW,	&inetdomain,	IPPROTO_ICMP,	PR_ATOMIC|PR_ADDR|PR_LASTHDR,
  icmp_input,	rip_output,	0,		rip_ctloutput,
  rip_usrreq,
  0,		0,		0,		0,		icmp_sysctl
},
#ifndef NORAWTCP
/* NOTE: pr_input & pr_ctlinput must match STREAM/TCP entry above! */
{ SOCK_RAW,	&inetdomain,	IPPROTO_TCP,	PR_ATOMIC|PR_ADDR,
  tcp_input,	rip_output,	tcp_ctlinput,	rip_ctloutput,
  tcp_usrreq,
  0,		0,		0,		0,		tcp_sysctl
},
#endif /* NORAWTCP */
#ifdef IPSEC
{ SOCK_RAW,	&inetdomain,	IPPROTO_AH,	PR_ATOMIC|PR_ADDR,
  ah4_input,	0, 		0,		0,
  0,
  0,		0,		0,		0,		ipsec_sysctl,
},
#ifdef IPSEC_ESP
{ SOCK_RAW,	&inetdomain,	IPPROTO_ESP,	PR_ATOMIC|PR_ADDR,
  esp4_input,	0, 		0,		0,
  0,
  0,		0,		0,		0,		ipsec_sysctl,
},
#endif
{ SOCK_RAW,	&inetdomain,	IPPROTO_IPCOMP,	PR_ATOMIC|PR_ADDR,
  ipcomp4_input, 0, 		0,		0,
  0,
  0,		0,		0,		0,		ipsec_sysctl,
},
#endif /* IPSEC */
{ SOCK_RAW,	&inetdomain,	IPPROTO_IPV4,	PR_ATOMIC|PR_ADDR|PR_LASTHDR,
  encap4_input,	rip_output, 	0,		rip_ctloutput,
  rip_usrreq,
  encap_init,	0,		0,		0,
#ifdef INET6
  ip6_sysctl,
#endif
},
#ifdef INET6
{ SOCK_RAW,	&inetdomain,	IPPROTO_IPV6,	PR_ATOMIC|PR_ADDR|PR_LASTHDR,
  encap4_input,	rip_output, 	0,		rip_ctloutput,
  rip_usrreq,
  encap_init,	0,		0,		0,		ip6_sysctl
},
#endif /* INET6 */
#if 0
{ SOCK_RAW,	&inetdomain,	IPPROTO_IPIP,	PR_ATOMIC|PR_ADDR|PR_LASTHDR,
  ipip_input,	rip_output,	0,		rip_ctloutput,
  rip_usrreq,/*XXX*/
  0,		0,		0,		0,		ip_sysctl,
},
#endif
{ SOCK_RAW,	&inetdomain,	IPPROTO_IGMP,	PR_ATOMIC|PR_ADDR|PR_LASTHDR,
  igmp_input,	rip_output,	0,		rip_ctloutput,
  rip_usrreq,
  igmp_init,	igmp_fasttimo,	igmp_slowtimo,	0,		igmp_sysctl
},
#ifdef TPIP
{ SOCK_SEQPACKET,&inetdomain,	IPPROTO_TP,	PR_CONNREQUIRED|PR_WANTRCVD|PR_LASTHDR,
  tpip_input,	0,		tpip_ctlinput,	tp_ctloutput,
  tp_usrreq,
  tp_init,	0,		tp_slowtimo,	tp_drain,
},
#endif
/* EON (ISO CLNL over IP) */
#ifdef EON
{ SOCK_RAW,	&inetdomain,	IPPROTO_EON,	PR_LASTHDR,
  eoninput,	0,		eonctlinput,		0,
  0,
  eonprotoinit,	0,		0,		0,
},
#endif
#ifdef NSIP
{ SOCK_RAW,	&inetdomain,	IPPROTO_IDP,	PR_ATOMIC|PR_ADDR|PR_LASTHDR,
  idpip_input,	rip_output,	nsip_ctlinput,	0,
  rip_usrreq,
  0,		0,		0,		0,
},
#endif
#ifdef	IPFW
/* IP Filter logging socket */
{ SOCK_RAW,	&inetdomain,	IPFW_PROTO,	PR_ATOMIC|PR_ADDR,
  0,		0,		0,		ipfw_ctloutput,
  raw_usrreq,
  0,		0,		0,		0,
  0,
},
#ifdef	IPFWFLOW
/* IP Filter logging socket */
{ SOCK_RAW,	&inetdomain,	IPFW_FLOW_PROTO,PR_ATOMIC|PR_ADDR,
  0,		0,		0,		0,
  raw_usrreq,
  0,		0,		0,		0,
  0,
},
#endif
#endif
	/* raw wildcard */
{ SOCK_RAW,	&inetdomain,	0,		PR_ATOMIC|PR_ADDR,
  rip_input,	rip_output,	0,		rip_ctloutput,
  rip_usrreq,
  rip_init,	0,		0,		0,
},
};

#if NGIF > 0
struct protosw in_gif_protosw =
{ SOCK_RAW,	&inetdomain,	0/*IPPROTO_IPV[46]*/,	PR_ATOMIC|PR_ADDR,
  in_gif_input, rip_output,	0,		rip_ctloutput,
#if defined(__FreeBSD__) && __FreeBSD__ >= 3
  0,
#else
  rip_usrreq,
#endif
  0,            0,              0,              0,
#if defined(__FreeBSD__) && __FreeBSD__ >= 3
  &rip_usrreqs
#endif
};
#endif /*NGIF*/

#if NSTF > 0
struct protosw in_stf_protosw =
{ SOCK_RAW,	&inetdomain,	IPPROTO_IPV6,	PR_ATOMIC|PR_ADDR,
  in_stf_input, rip_output,	0,		rip_ctloutput,
  rip_usrreq,
  0,            0,              0,              0
};
#endif /*NSTF*/

extern int in_inithead(void **, int);

struct domain inetdomain =
    { AF_INET, "internet", 0, 0, 0,
      inetsw, &inetsw[sizeof(inetsw)/sizeof(inetsw[0])], 0,
      in_inithead, 32, sizeof(struct sockaddr_in) };

#include "imp.h"
#if NIMP > 0
extern	struct domain impdomain;
int	rimp_output(), hostslowtimo();

struct protosw impsw[] = {
{ SOCK_RAW,	&impdomain,	0,		PR_ATOMIC|PR_ADDR,
  0,		rimp_output,	0,		0,
  rip_usrreq,
  0,		0,		hostslowtimo,	0,
},
};

struct domain impdomain =
    { AF_IMPLINK, "imp", 0, 0, 0,
      impsw, &impsw[sizeof (impsw)/sizeof(impsw[0])] };
#endif

#include "hy.h"
#if NHY > 0
/*
 * HYPERchannel protocol family: raw interface.
 */
int	rhy_output();
extern	struct domain hydomain;

struct protosw hysw[] = {
{ SOCK_RAW,	&hydomain,	0,		PR_ATOMIC|PR_ADDR,
  0,		rhy_output,	0,		0,
  rip_usrreq,
  0,		0,		0,		0,
},
};

struct domain hydomain =
    { AF_HYLINK, "hy", 0, 0, 0, hysw, &hysw[sizeof (hysw)/sizeof(hysw[0])] };
#endif

/*
 * Internet configuration info
 */
#ifndef	IPFORWARDING
#ifdef GATEWAY
#define	IPFORWARDING	1	/* forward IP packets not for us */
#else /* GATEWAY */
#define	IPFORWARDING	0	/* don't forward IP packets not for us */
#endif /* GATEWAY */
#endif /* IPFORWARDING */

#ifndef IPFORWARDSRCRT
#if IPFORWARDING==0 || defined(GWSCREEN) || defined(IPFW)
#define	IPFORWARDSRCRT	0	/* don't forward source-routed IP packets */
#else
#define	IPFORWARDSRCRT	1	/* forward source-routed IP packets */
#endif /* GWSCREEN */
#endif /* IPFORWARDSRCRT */

#ifndef	IPSENDREDIRECTS
#define	IPSENDREDIRECTS	1
#endif

#ifndef	IPSOURCECHECK
#define	IPSOURCECHECK	0
#endif

#ifndef	IFQMAXLEN
#define	IFQMAXLEN	IFQ_MAXLEN
#endif

int	ipforwarding = IPFORWARDING;		/* act as router? */
int	ipforward_srcrt = IPFORWARDSRCRT;	/* forward src-routed? */
int	ipsendredirects = IPSENDREDIRECTS;
int	ip_defttl = IPDEFTTL;
int	ip_sourcecheck = IPSOURCECHECK;		/* check source if on packets */
int	ip_sourcecheck_interval = 5;		/* minimum time between syslogs */
int	ip_maxfragpackets = 200;
int	ipqmaxlen = IFQMAXLEN;
#if	defined(IPFW)
int	ip_do_rfc1858 = 1;			/* check for frag offset of 1 */
#else
int	ip_do_rfc1858 = 0;
#endif

#ifndef	IN_ADDRHASH
#ifndef INET_SERVER
#define	IN_ADDRHASH	23
#else
#define	IN_ADDRHASH	997
#endif
#endif
struct	inhash *inhash[IN_ADDRHASH];	/* hash buckets for local IP addrs */
int	in_nhash = IN_ADDRHASH;		/* number of hash buckets for addrs */

/*
 * If ip_input is compiled with GWSCREEN, it will call via ip_forward_fn
 * to forward packets.  The same binary will work for systems compiled
 * with or without GWSCREEN by initializing ip_forward_fn here
 * depending on the configuration when this (config-dependent) file
 * is compiled.
 *
 * ip_forwardscreen() really does not know how to deal with the third
 * argument, but we cope with that in ip_forward.
 */
#ifdef GWSCREEN
void ip_forwardscreen __P((struct mbuf *, int, int));
void (*ip_forward_fn) __P((struct mbuf *, int, int)) = ip_forwardscreen;
#else
void (*ip_forward_fn) __P((struct mbuf *, int, int)) = ip_forward;
#endif

#ifndef MROUTING
#include <netinet/ip_mroute.h>

/* dummies when MROUTING is not defined */
struct	socket *ip_mrouter;

int
ip_mrouter_set(cmd, so, m)
	int cmd;
	struct socket *so;
	struct mbuf *m;
{
	return (EOPNOTSUPP);
}

int
ip_mrouter_get(cmd, so, m)
	int cmd;
	struct socket *so;
	struct mbuf *m;
{
	return (EOPNOTSUPP);
}

int
mrt_ioctl(cmd, data)
	int cmd;
	caddr_t data;
{
	return (EINVAL);
}

ip_mrouter_done() { ; }

int
ip_mforward(ip, ifp, m)
	struct ip *ip;
	struct ifnet *ifp;
	struct mbuf *m;
{

	return (0);
}

int
ip_msysctl(name, namelen, oldp, oldlenp, newp, newlen)
	int *name;
	u_int namelen;
	void *oldp;
	size_t *oldlenp;
	void *newp;
	size_t newlen;
{
	return (EOPNOTSUPP);
}
#endif /* !MROUTING */

/* raw IP parameters */
/*
 * Nominal space allocated to a raw ip socket.
 */
#define	RIPSNDQ		8192
#define	RIPRCVQ		8192

u_long	rip_sendspace = RIPSNDQ;
u_long	rip_recvspace = RIPRCVQ;

/* ICMP parameters */
#ifdef GATEWAY
int	icmpmaskrepl = 1;
#else
int	icmpmaskrepl = 0;
#endif
int	icmpbmcastecho = 1;
int	icmp_rediraccept = 1;		/* accept and process redirects */
int	icmp_redirtimeout = 10 * 60;	/* 10 minutes */
#ifdef ICMPPRINTFS
int	icmpprintfs = 0;
#endif

/* TCP parameters */
int	tcp_sendspace = 1024 * 8;
int	tcp_recvspace = 1024 * 8;
int 	tcp_mssdflt = TCP_MSS;
int 	tcp_rttdflt = TCPTV_SRTTDFLT / PR_SLOWHZ;
int	tcp_do_rfc1323 = 1;
int	tcp_conntimeo = TCPTV_KEEP_INIT;	/* initial connection timeout */
int	tcp_pmtu = 1;			/* Enable path MTU discovery code */
int	tcp_43maxseg = 0;		/* Always use mtu of local interface */
int	tcp_ifpmaxseg = 0;		/* For MSS, use mtu of outgoing ifp */
/*
 * These are the maximum useful ages for discovered Path MTU info,
 * and probed Path MTU info.  These values are in seconds.
 */
int	pmtu_expire = 60*10;		/* 10 minutes */
int	pmtu_probe = 60*2;		/* 2 minutes */


/*
 * Parameters for keepalive option.
 * Connections for which SO_KEEPALIVE is set will be probed
 * after being idle for a time of tcp_keepidle (in units of PR_SLOWHZ).
 * Starting at that time, the connection is probed at intervals
 * of tcp_keepintvl (same units) until a response is received
 * or until tcp_keepcnt probes have been made, at which time
 * the connection is dropped.  Note that a tcp_keepidle value
 * under 2 hours is nonconformant with RFC-1122, Internet Host Requirements.
 */
int	tcp_keepidle = TCPTV_KEEP_IDLE;		/* time before probing idle */
int	tcp_keepintvl = TCPTV_KEEPINTVL;	/* interval betwn idle probes */
int	tcp_keepcnt = TCPTV_KEEPCNT;		/* max idle probes */
int	tcp_maxpersistidle = TCPTV_KEEP_IDLE;	/* max idle time in persist */

#ifndef INET_SERVER
#define	TCP_LISTEN_HASH_SIZE	17
#define	TCP_CONN_HASH_SIZE	97
#define	TCP_SYN_HASH_SIZE	293
#define	TCP_SYN_BUCKET_SIZE	35
#else
#define	TCP_LISTEN_HASH_SIZE	97
#define	TCP_CONN_HASH_SIZE	9973
#define	TCP_SYN_HASH_SIZE	997
#define	TCP_SYN_BUCKET_SIZE	35
#endif
int	tcp_listen_hash_size = TCP_LISTEN_HASH_SIZE;
int	tcp_conn_hash_size = TCP_CONN_HASH_SIZE;
struct	tcp_hash_list tcp_listen_hash[TCP_LISTEN_HASH_SIZE],
	tcp_conn_hash[TCP_CONN_HASH_SIZE];
#ifndef NORAWTCP
struct	tcp_hash_list tcp_raw_hash;
#endif /* NORAWTCP */

int	tcp_syn_cache_size = TCP_SYN_HASH_SIZE;
int	tcp_syn_cache_limit = TCP_SYN_HASH_SIZE*TCP_SYN_BUCKET_SIZE;
int	tcp_syn_bucket_limit = 3*TCP_SYN_BUCKET_SIZE;
struct	syn_cache_head tcp_syn_cache[TCP_SYN_HASH_SIZE];
struct	syn_cache_head *tcp_syn_cache_first;
int	tcp_syn_cache_interval = 8;	/* runs timer every 4 seconds */
int	tcp_syn_cache_timeo = TCPTV_KEEP_INIT;

/*
 * Parameters for computing a desirable data segment size
 * given an upper bound (either interface MTU, or peer's MSS option)_.
 * As applications tend to use a buffer size that is a multiple
 * of kilobytes, try for something that divides evenly. However,
 * do not round down too much.
 *
 * Round segment size down to a multiple of TCP_ROUNDSIZE if this
 * does not result in lowering by more than (size/TCP_ROUNDFRAC).
 * For example, round 536 to 512.  Older versions of the system
 * effectively used MCLBYTES (1K or 2K) as TCP_ROUNDSIZE, with
 * a value of 1 for TCP_ROUNDFRAC (eliminating its effect).
 * We round to a multiple of 256 for SLIP.
 *
 * If the MTU is greater than 2K, then just round down to the
 * nearest 1K boundry.
 */
#ifndef	TCP_ROUNDSIZE
#define	TCP_ROUNDSIZE	256	/* round to multiple of 256 */
#endif
#ifndef	TCP_ROUNDFRAC
#define	TCP_ROUNDFRAC	10	/* round down at most N/10, or 10% */
#endif
#ifndef	TCP_ROUND1K
#define	TCP_ROUND1K	2048
#endif

int	tcp_roundsize = TCP_ROUNDSIZE;
int	tcp_roundfrac = TCP_ROUNDFRAC;
int	tcp_round1k = TCP_ROUND1K;

int
tcp_mss_round(val)
	int val;
{
	int frag;

	if (val > tcp_round1k)
		val &= ~0x3ff;	/* round down to nearest 1K boundry */
	else if (val > tcp_roundsize &&
	    (frag = val % tcp_roundsize) <= val / tcp_roundfrac)
		val -= frag;
	return (val);
}

/* UDP parameters */
#ifdef INET6
int	udp_sendspace = 9224;		/* 9200+sizeof(struct sockaddr_in6) */
int	udp_recvspace = 40 * (1024 + sizeof(struct sockaddr_in6));
					/* 40 1K datagrams */
#else /* INET6 */

int	udp_sendspace = 9216;		/* really max datagram size */
int	udp_recvspace = 40 * (1024 + sizeof(struct sockaddr_in));
					/* 40 1K datagrams */
#endif /* INET6 */

#ifndef SOURCE
/*
 * Since the OBJ tree has INET6, IPSEC and IPSEC_ESP all
 * defined when they are built, we need to put in stub routines to
 * allow binary systems to link without them.
 */

# ifndef INET6

struct ifqueue ip6intrq;
int ip6_defhlim = IPV6_DEFHLIM;
u_char  inet6ctlerrmap[PRC_NCMDS];
struct ip6stat ip6stat;
int ip6_auto_flowlabel = 1;
int ip6_use_deprecated = 1;
const struct sockaddr_in6 sa6_any = {sizeof(sa6_any), AF_INET6,
					0, 0, IN6ADDR_ANY_INIT, 0};

#if NGIF > 0
struct ip6protosw *in6_gif_protoswptr = NULL;

int
gif_encapcheck6(const struct mbuf *m, int off, int proto, void *arg)
{
	return(0);
}

int
in6_gif_output(struct ifnet *ifp, int family, struct mbuf *m,
    struct rtentry *rt)
{
	m_freem(m);
	return EAFNOSUPPORT;
}
#endif /*NGIF*/



void
icmp6_error(struct mbuf *m, int type, int code, int param)
{
	m_freem(m);
}


in6_cksum(struct mbuf *m, u_int8_t proto, u_int32_t len, u_int32_t start)
{
	return (0);
}

int
in6_control(struct socket *so, int cmd, caddr_t data, struct ifnet *ifp,
    int internal)
{
	return (EOPNOTSUPP);
}

int
in6_pcbbind(struct inpcb *inp, struct mbuf *nam)
{
	return (EAFNOSUPPORT);
}

int
in6_pcbconnect(struct inpcb *inp, struct mbuf *nam)
{
	return (EAFNOSUPPORT);
}

int
in6_pcbnotify(struct inpcb *head, struct sockaddr *dst,
    u_int fport_arg, struct sockaddr *src, u_int lport_arg,
    int cmd, void *cmdarg, void (*notify) __P((struct inpcb *, int)))
{
	return (1);
}

int
in6_pcbsetport(struct in6_addr *laddr, struct in6pcb *in6p)
{
	return(EAFNOSUPPORT);
}

int
in6_recoverscope(struct sockaddr_in6 *sin6, const struct in6_addr *in6,
    struct ifnet *ifp)
{
        return 0;
}

int
in6_selecthlim(struct inpcb *in6p, struct ifnet *ifp)
{
	return(ip6_defhlim);
}

struct in6_addr *
in6_selectsrc(struct sockaddr_in6 *dstsock, struct ip6_pktopts *opts,
    struct ip6_moptions *mopts, struct route *ro,
    struct in6_addr *laddr, int *errorp)
{
	*errorp = EADDRNOTAVAIL;
	return(0);
}

int
in6_setpeeraddr(struct inpcb *inp, struct mbuf *nam)
{
	return (0);
}

int
in6_setsockaddr(struct inpcb *inp, struct mbuf *nam)
{
	return (0);
}

void
ip6_clearpktopts(struct ip6_pktopts *pktopt, int needfree, int optname)
{
	return;
}

struct ip6_pktopts *
ip6_copypktopts(struct ip6_pktopts *src, int canwait)
{
	return(NULL);
}

int
ip6_ctloutput(int op, struct socket *so, int level,
    int optname, struct mbuf **mp)
{
	return (EINVAL);
}


void
ip6_freemoptions(struct ip6_moptions *i6mo)
{
	return;
}

void
ip6_freepcbopts(struct ip6_pktopts *pktopt)
{
        if (pktopt == NULL)
                return;
        free(pktopt, M_IP6OPT);
}

struct in6_ifaddr *
ip6_getdstifaddr(struct mbuf *m)
{
	return NULL;
}

int
ip6_output(struct mbuf *m0, struct ip6_pktopts *opt,
    struct route *ro,
    int flags, struct ip6_moptions *im6o, struct ifnet **ifpp)
{
	if (m0)
		m_freem(m0);
	return (EHOSTUNREACH);
}

void
ip6_savecontrol(struct inpcb *in6p, struct ip6_hdr *ip6, struct mbuf *m,
    struct ip6_recvpktopts *ctl, struct ip6_recvpktopts **prevctlp)
{
	return;
}

int
ip6_setpktoptions(struct mbuf *control, struct ip6_pktopts *opt, int priv,
    int needcopy)
{
	return(EINVAL);
}

void
ip6_update_recvpcbopt(struct ip6_recvpktopts *new, struct ip6_recvpktopts *old)
{
	return;
}

void
nd6_nud_hint(struct rtentry *rt, struct in6_addr *dst6)
{
	return;
}

int
rip6_input(struct mbuf **mp, int *offp, int proto)
{
	if (mp && *mp)
		m_freem(*mp);
	return IPPROTO_DONE;
}

int
udp6_output(struct in6pcb *in6p, struct mbuf *m, struct mbuf *addr6,
    struct mbuf *control)
{
	return(EAFNOSUPPORT);
}

#  ifdef IPSEC
struct in6_ifaddr *in6_ifaddr;
size_t in6_ifstatmax = 0;
struct in6_ifstat **in6_ifstat = NULL;

int
ip6_nexthdr(struct mbuf *m, int off, int proto, int *nxtp)
{
	return -1;
}

int
ip6_lasthdr(struct mbuf *m, int off, int proto, int *nxtp)
{
	return -1;
}

char *
ip6_sprintf(struct in6_addr *addr)
{
	return("xx::xx");
}

char *
ip6_get_prevhdr(struct mbuf *m, int off)
{
	return NULL;
}

void
icmp6_mtudisc_update(struct ip6ctlparam *ip6cp, int validated)
{
	return;
}

void
pfctlinput2(int cmd, struct sockaddr *sa, void *ctlparam)
{
	return;
}

#  endif /* IPSEC */
# endif /* INET6 */

# ifndef IPSEC

#include <netinet6/ipsec.h>

struct ipsecstat ipsec6stat;
struct ipsecstat ipsecstat;


int
ipsec4_delete_pcbpolicy(struct inpcb *inp)
{
	return 0;
}

int
ipsec4_get_policy(struct inpcb *inp, caddr_t request,
    size_t len, struct mbuf **mp)
{
	return EINVAL;
}

static struct secpolicy dummy_policy = {
	{ NULL, NULL }, 0, { 0, }, 0,
	IPSEC_SPSTATE_ALIVE, IPSEC_POLICY_NONE, NULL
};

struct secpolicy *
ipsec4_getpolicybyaddr(struct mbuf *m, u_int dir, int flag, int *error)
{
	return &dummy_policy;
}

struct secpolicy *
ipsec4_getpolicybysock(struct mbuf *m, u_int dir, struct socket *so, int *error)
{
	if (error)
		*error = 0;
	return &dummy_policy;
}

struct secpolicy *
ipsec6_getpolicybyaddr(struct mbuf *m, u_int dir, int flag, int *error)
{
	return &dummy_policy;
}

struct secpolicy *
ipsec6_getpolicybysock(struct mbuf *m, u_int dir, struct socket *so, int *error)
{
	if (error)
		*error = 0;
	return &dummy_policy;
}

size_t
ipsec4_hdrsiz( struct mbuf *m, u_int dir, struct inpcb *inp)
{
	return 0;
}

int
ipsec4_in_reject(struct mbuf *m, struct inpcb *inp)
{
	return 0;
}

int
ipsec4_in_reject_so(struct mbuf *m, struct socket *so)
{
	return 0;
}

int
ipsec4_output(struct ipsec_output_state *state, struct secpolicy *sp, int flags)
{
	return (0);
}

int
ipsec4_set_policy(struct inpcb *inp, int optname, caddr_t request,
    size_t len, int priv)
{
	return EINVAL;
}

int
ipsec6_get_policy(struct inpcb *in6p, caddr_t request, size_t len,
    struct mbuf **mp)
{
	return EINVAL;
}

size_t
ipsec6_hdrsiz(struct mbuf *m, u_int dir, struct inpcb *in6p)
{
	return 0;
}

int
ipsec6_in_reject(struct mbuf *m, struct inpcb *inp)
{
	return 0;
}

int
ipsec6_in_reject_so(struct mbuf *m, struct socket *so)
{
	return 0;
}

int
ipsec6_output_trans(struct ipsec_output_state *state, u_char *nexthdrp,
    struct mbuf *mprev, struct secpolicy *sp, int flags, int *tun)
{
	return EINVAL;
}

int
ipsec6_output_tunnel(struct ipsec_output_state *state, struct secpolicy *sp,
    int flags)
{
	return EINVAL;
}

int
ipsec6_set_policy(struct inpcb *in6p, int optname, caddr_t request,
    size_t len, int priv)
{
	return EINVAL;
}

int
ipsec_copy_policy(struct inpcbpolicy *old, struct inpcbpolicy *new)
{
	return 0;
}

void
ipsec_delaux(struct mbuf *m)
{
	return;
}


struct socket *
ipsec_getsocket(struct mbuf *m)
{
	return NULL;
}

int
ipsec_init_policy(struct socket *so, struct inpcbpolicy **pcb_sp)
{
	return 0;
}

int
ipsec_setsocket(struct mbuf *m, struct socket *so)
{
	return 0;
}

void
key_freesp(struct secpolicy *sp)
{
        return;
}

void
key_sa_routechange(struct sockaddr *dst)
{
	return;
}

int
key_spdacquire(struct secpolicy *sp)
{
	return ENOBUFS;
}
# endif /* IPSEC */

# ifndef IPSEC_ESP

#include <netinet6/esp.h>

int
esp6_input(struct mbuf **mp, int *offp, int proto)
{
	if (*mp)
		m_freem(*mp);
	return IPPROTO_DONE;
}

struct esp_algorithm esp_algorithms[1];

size_t
esp_hdrsiz(struct ipsecrequest *isr)
{
	return 0;
}

int
esp4_output(struct mbuf *m, struct ipsecrequest *isr)
{
	m_freem(m);
	return NULL;
}

int
esp6_output(struct mbuf *m, u_char *nexthdrp, struct mbuf *md,
    struct ipsecrequest *isr)
{
	m_freem(m);
	return NULL;
}

const struct esp_algorithm *
esp_algorithm_lookup(int idx)
{
	return NULL;
}

# endif /* IPSEC_ESP */

# ifndef IPFW
int
sysctl_ipfw(name, namelen, oldp, oldlenp, newp, newlen)
	int *name;
	u_int namelen;
	void *oldp;
	size_t *oldlenp;
	void *newp;
	size_t newlen;
{

	return (EOPNOTSUPP);
}
# endif /* IPFW */

# ifndef IPRF
int
sysctl_ratefilter(name, namelen, oldp, oldlenp, newp, newlen)
	int *name;
	u_int namelen;
	void *oldp;
	size_t *oldlenp;
	void *newp;
	size_t newlen;
{

	return (EOPNOTSUPP);
}

int
ip_rateoutput(ifp, m, dst, rt)
        struct ifnet *ifp;
        struct mbuf *m;
        struct sockaddr *dst;
        struct rtentry *rt;
{

	return ((*ifp->if_output)(ifp, m, dst, rt));
}
# endif /* IPRF */

#include "faith.h"
# if NFAITH < 1
int
faithprefix(struct in6_addr *in6)
{
	return 0;
}
# endif /* NFAITH */
#endif
