/*-
 * Copyright (c) 1999 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI ipfw_echochk.h,v 1.1 2000/01/21 20:38:45 prb Exp
 */

/*
 * This structure is passed in/out of the kernel to describe a cirucit cache.
 * The length field is ignored when read in by the kernel.
 */
typedef struct {
	u_int		ec_size;	/* number of buckets in circuit */
	u_int		ec_entries;	/* number of entries in the cache */
	u_int		ec_maxentries;	/* maximum flows allowed */
} ip_echochk_hdr_t;

/*
 * Once of these per circuit, try to keep as small as possible.
 */
typedef struct ip_echochk {
#ifdef	KERNEL
	struct	ip_echochk *ec_next;	/* Next entry in bucket */
	struct	ip_echochk *ec_prev;	/* Previous entry in bucket */
	struct	ip_echochk *ec_older;	/* Next entry older than us */
	struct	ip_echochk *ec_newer;	/* Next entry younger than us */
	struct	ip_echochk_head	*ec_head;
#else
	void		*ec_private[5];
#endif
	u_long		ec_hash;
	struct in_addr	ec_a[2];
	u_long		ec_when;	/* last time we were looked at */
	u_int32_t	ec_idseq;	/* Ports used in this echochk */
} ip_echochk_t;

#define ECHOCHK_HASH_SIZE       997


#define	IPFWECHOCHK_CLOCK	1
#define	IPFWECHOCHK_BUCKETS	2
