/*-
 * Copyright (c) 1999 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI ipfw_flow.h,v 1.4 1999/10/14 02:13:15 prb Exp
 */

/*
 * This structure is passed in/out of the kernel to describe a cirucit cache.
 * The length field is ignored when read in by the kernel.
 */
typedef struct {
	u_int	size;			/* number of buckets in circuit */
	u_int	flows;			/* number of entries in the cache */
	u_int	prefill;		/* flows to prefill */
	u_int	maxflows;		/* maximum flows allowed */
	int	index;			/* interface to filter */
	int	glue;			/* who we should glue ourselves to */
	int	direction;		/* to swap or not to swap */
} ip_flow_hdr_t;

/*
 * Once of these per circuit, try to keep as small as possible.
 */
typedef struct ip_flow {
#ifdef	KERNEL
	struct	ip_flow *fl_next;	/* Next entry in bucket */
	struct	ip_flow *fl_prev;	/* Previous entry in bucket */
	struct	ip_flow *fl_older;	/* Next entry older than us */
	struct	ip_flow *fl_newer;	/* Next entry younger than us */
	struct	ip_flow_head	*fl_head;
#else
	void		*fl_private[5];
#endif
	u_int32_t	fl_ports;	/* Ports used in this flow */
	u_quad_t	fl_hash;
	u_quad_t	fl_start;	/* Time we first saw the flow */
	u_quad_t	fl_last;	/* Last time we saw this flow */
	struct	in_addr	fl_a[2];	/* Addresses */
	u_quad_t	fl_packets[2];	/* Number of packets in flow */
	u_quad_t	fl_bytes[2];	/* Number of packets in flow */
	u_char		fl_protocol;	/* Protocol in this flow */
} ip_flow_t;

/*
 * This data is overlayed on the above structure when logging a packet
 */
typedef struct {
	u_int16_t	fl_type;	/* type of packet */
	u_int16_t	fl_length;	/* length of packet */
	int		fl_serial;	/* serial of filter we came from */
	struct timespec	fl_expired;	/* when we expired */
} ip_flow_log_hdr_t;

#define	IPFWFLOW_EXPIRED	1	/* flow expired */

#define	IPFWFLOW_CLOCK		1
#define	IPFWFLOW_BUCKETS	2

#define FLOW_HASH_SIZE       997

#define CCPG    (NBPG / sizeof(ip_flow_t))
