/*-
 * Copyright (c) 1998 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI ipfw_var.c,v 2.6 2000/03/06 04:43:20 prb Exp
 */

#include <sys/param.h>
#include <sys/systm.h>
#include <sys/mbuf.h>

#include <netinet/ipfw.h>

/*
 * The filters.
 * Indicate which fields should be byte swapped and if the filter is allowed
 * to modify the packet.
 */
static ipfw_stats_t ipfw_preinput_stats;
static ipfw_stats_t ipfw_input_stats;
static ipfw_stats_t ipfw_forward_stats;
static ipfw_stats_t ipfw_output_stats;
static ipfw_stats_t ipfw_preoutput_stats;
static ipfw_stats_t ipfw_call_stats;
static ipfw_stats_t ipfw_rate_stats;

ipfw_t ipfw_preinput = { IPFWF_MODIFY, &ipfw_preinput_stats, };
ipfw_t ipfw_input = { 0, &ipfw_input_stats, };
ipfw_t ipfw_forward = { 0, &ipfw_forward_stats, };
ipfw_t ipfw_output = { 0, &ipfw_output_stats, };
ipfw_t ipfw_preoutput = { IPFWF_MODIFY, &ipfw_preoutput_stats, };
ipfw_t ipfw_rate = { 0, &ipfw_rate_stats, };

/*
 * The call list is special, we fudge it to appear that there is an
 * entry on the list that we never remove.  This is needed to make sure
 * the filters pointed to by ipfw_filters don't move on us.
 */
ipfw_t ipfw_call = { IPFWF_CALL, &ipfw_call_stats, 0, 0, INT_MAX, "",
    (void *)&ipfw_call, };

ipfw_call_t *ipfw_filters; 
int ipfw_nfilters;

/*
 * The table below contains the push point for each of the various
 * filter types.  This is the only connection between the ipfw.c
 * module and the various filter type modules.
 */
extern int ipfw_bpf_filter_push __P((ipfw_t *, void *, size_t));
extern int ipfw_cisco_push __P((ipfw_t *, void *, size_t));
extern int ipfw_circuit_push __P((ipfw_t *, void *, size_t));
extern int ipfw_flow_push __P((ipfw_t *, void *, size_t));
extern int ipfw_nat_push __P((ipfw_t *, void *, size_t));
extern int ipfw_throttle_push __P((ipfw_t *, void *, size_t));
extern int ipfw_echochk_push __P((ipfw_t *, void *, size_t));
extern int ipfw_cache_push __P((ipfw_t *, void *, size_t));
extern int ipfw_rewrite_push __P((ipfw_t *, void *, size_t));

#ifdef	IPFW
ipfw_type_t ipfw_types[] = {
	{ IPFW_BPF,		ipfw_bpf_filter_push, },
	{ IPFW_CISCO,		ipfw_cisco_push, },
	{ IPFW_CIRCUIT,		ipfw_circuit_push, },
	{ IPFW_CACHE,		ipfw_cache_push, },
	{ IPFW_REWRITE,		ipfw_rewrite_push, },
#ifdef	IPFWFLOW
	{ IPFW_FLOW,		ipfw_flow_push, },
#endif
#ifdef	IPFWNAT
	{ IPFW_NAT,		ipfw_nat_push, },
#endif
#ifdef	IPFWTHROTTLE
	{ IPFW_THROTTLE,	ipfw_throttle_push, },
#endif
#ifdef	IPFWECHOCHK
	{ IPFW_ECHOCHK,		ipfw_echochk_push, },
#endif
	{ 0, },
};
#endif
