/*	BSDI icmpv6.h,v 1.3 2000/05/02 15:09:05 dab Exp	*/
/*
 * This file provides (some) backwards compatability
 * with BSD/OS 4.x, which used the NRL IPv6/IPSec code.
 */

#ifndef NRL_COMPAT
#error "You must define NRL_COMPAT to include <netinet6/icmpv6.h>"
#endif /* NRL_COMPAT */

#ifndef _NETINET6_ICMPV6_H
#define _NETINET6_ICMPV6_H

#include <netinet/icmp6.h>

/* struct icmpv6hdr */
#define icmpv6hdr	icmp6_hdr

#define icmpv6_type		icmp6_type
#define	icmpv6_code		icmp6_code
#define	icmpv6_cksum		icmp6_cksum

#define icmpv6_data32		icmp6_data32
#define icmpv6_data16		icmp6_data16
#define icmpv6_data8		icmp6_data8
#define icmpv6_pptr		icmp6_pptr
#define icmpv6_mtu		icmp6_mtu
#define icmpv6_id		icmp6_id
#define icmpv6_seq		icmp6_seq
#define icmpv6_maxdelay		icmpv6_maxdelay

#define ICMPV6_DST_UNREACH		ICMP6_DST_UNREACH
#define ICMPV6_PACKET_TOOBIG		ICMP6_PACKET_TOO_BIG
#define ICMPV6_TIME_EXCEEDED		ICMP6_TIME_EXCEEDED
#define ICMPV6_PARAMETER_PROBLEM	ICMP6_PARAM_PROB

#define ICMPV6_INFOMSG_MASK		ICMP6_INFOMSG_MASK

#define ICMPV6_ECHO_REQUEST		ICMP6_ECHO_REQUEST
#define ICMPV6_ECHO_REPLY		ICMP6_ECHO_REPLY
#define ICMPV6_MEMBERSHIP_QUERY		ICMP6_MEMBERSHIP_QUERY
#define ICMPV6_MEMBERSHIP_REPORT	ICMP6_MEMBERSHIP_REPORT
#define ICMPV6_MEMBERSHIP_REDUCTION	ICMP6_MEMBERSHIP_REDUCTION


#define ICMPV6_UNREACH_NOROUTE		ICMP6_DST_UNREACH_NOROUTE
#define ICMPV6_UNREACH_ADMIN		ICMP6_DST_UNREACH_ADMIN
#define ICMPV6_UNREACH_NOTNEIGHBOR	ICMP6_DST_UNREACH_NOTNEIGHBOR
#define ICMPV6_UNREACH_ADDRESS		ICMP6_DST_UNREACH_ADDR
#define ICMPV6_UNREACH_PORT		ICMP6_DST_UNREACH_NOPORT

#define ICMPV6_EXCEEDED_HOPS		ICMP6_TIME_EXCEED_TRANSIT
#define ICMPV6_EXCEEDED_REASSEMBLY	ICMP6_TIME_EXCEED_REASSEMBLY


#define ICMPV6_PARAMPROB_HDR		ICMP6_PARAMPROB_HEADER
#define ICMPV6_PARAMPROB_NEXTHDR	ICMP6_PARAMPROB_NEXTHEADER
#define ICMPV6_PARAMPROB_OPTION		ICMP6_PARAMPROB_OPTION

#define	icmpv6_filter	icmp6_filter

#define ICMPV6_FILTER_WILLPASS 		ICMP6_FILTER_WILLPASS
#define ICMPV6_FILTER_WILLBLOCK 		ICMP6_FILTER_WILLBLOCK
#define ICMPV6_FILTER_SETPASS		ICMP6_FILTER_SETPASS
#define ICMPV6_FILTER_SETBLOCK		ICMP6_FILTER_SETBLOCK
#define ICMPV6_FILTER_SETPASSALL	ICMP6_FILTER_SETPASSALL
#define ICMPV6_FILTER_SETBLOCKALL	ICMP6_FILTER_SETBLOCKALL

#endif /* _NETINET6_ICMPV6_H */
