/*	BSDI nd6_protocol.h,v 1.3 2000/05/02 15:09:05 dab Exp	*/
/*
 * This file provides (some) backwards compatability
 * with BSD/OS 4.x, which used the NRL IPv6/IPSec code.
 */

#ifndef NRL_COMPAT
#error "You must define NRL_COMPAT to include <netinet6/nd6_protocol.h>"
#endif /* NRL_COMPAT */

#ifndef _NETINET6_ND6_PROTOCOL_H
#define _NETINET6_ND6_PROTOCOL_H 1

#include <netinet6/icmpv6.h>

#define ND6_ROUTER_SOLICITATION		ND_ROUTER_SOLICIT
#define ND6_ROUTER_ADVERTISEMENT	ND_ROUTER_ADVERT
#define ND6_NEIGHBOR_SOLICITATION	ND_NEIGHBOR_SOLICIT
#define ND6_NEIGHBOR_ADVERTISEMENT	ND_NEIGHBOR_ADVERT
#define ND6_REDIRECT	ND_REDIRECT

enum nd6_option {
	ND6_OPT_SOURCE_LINKADDR=1,	
	ND6_OPT_TARGET_LINKADDR=2,
	ND6_OPT_PREFIX_INFORMATION=3,
	ND6_OPT_REDIRECTED_HEADER=4,
	ND6_OPT_MTU=5,
	ND6_OPT_ENDOFLIST=256
};
	
/* struct nd_router_solicit */
#define	rsol_hdr	nd_rs_hdr

#define rsol_type		nd_rs_hdr.icmp6_type
#define rsol_code		nd_rs_hdr.icmp6_code
#define rsol_cksum		nd_rs_hdr.icmp6_cksum
#define rsol_reserved		nd_rs_hdr.icmp6_data32[0]
	
/* struct nd_router_advert */
#define	radv_hdr	nd_ra_hdr
#define	radv_reachable		nd_ra_reachable
#define	radv_retransmit		nd_ra_retransmit
	
#define radv_type		nd_ra_hdr.icmp6_type
#define radv_code		nd_ra_hdr.icmp6_code
#define radv_cksum		nd_ra_hdr.icmp6_cksum
#define radv_maxhoplimit	nd_ra_hdr.icmp6_data8[0]
#define radv_m_o_res		nd_ra_hdr.icmp6_data8[1]
#define ND6_RADV_M_BIT		ND_RA_FLAG_MANAGED
#define ND6_RADV_O_BIT		ND_RA_FLAG_OTHER
#define radv_router_lifetime	nd_ra_hdr.icmp6_data16[1]

/* struct nd6_nsolicitation */
#define	nd6_nsolicitation	nd_neighbor_solicit
#define	nsol6_hdr		nd_ns_hdr
#define	nsol6_target		nd_ns_target

/* struct nd6_nadvertisement */
#define	nd6_nadvertisement	nd_neighbor_advert
#define	nadv6_hdr		nd_na_hdr
#define	nadv6_target		nd_na_target
#define nadv6_flags		nd_na_flags_reserved

#define ND6_NADVERFLAG_ISROUTER		ND_NA_FLAG_ROUTER
#define ND6_NADVERFLAG_SOLICITED	ND_NA_FLAG_SOLICITED
#define ND6_NADVERFLAG_OVERRIDE		ND_NA_FLAG_OVERRIDE

/* struct nd6_redirect */
#define nd6_redirect		nd_redirect
#define	redirect_hdr		nd_rd_hdr
#define	redirect_target		nd_rd_target
#define	redirect_destination	nd_rd_dst
	
/* Structure elements are too generic for #defines... */
struct nd6_opt_prefix_info {	/* prefix information */
	u_int8_t	opt_type;
	u_int8_t	opt_length;
	u_int8_t	opt_prefix_length;
	u_int8_t	opt_l_a_res;
	u_int32_t	opt_valid_life;
	u_int32_t	opt_preferred_life;
	u_int32_t	opt_reserved2;
	struct in6_addr	opt_prefix;
};

#define ND6_OPT_PI_L_BIT	ND_OPT_PI_FLAG_ONLINK
#define ND6_OPT_PI_A_BIT	ND_OPT_PI_FLAG_AUTO
	
/* Structure elements are too generic for #defines... */
struct nd6_opt_mtu {	/* MTU option */
	u_int8_t	opt_type;
	u_int8_t	opt_length;
	u_int16_t	opt_reserved;
	u_int32_t	opt_mtu;
};
#endif /* _NETINET6_ND6_PROTOCOL_H */
