/*-
 * Copyright (c) 2001 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI pthread_var.h,v 1.1.2.1 2001/04/10 04:23:03 donn Exp
 */

/*
 * Machine-dependent definitions for our pthread implementation.
 * Currently this file contains only user-mode information.
 */

#ifndef _MACHINE_PTHREAD_VAR_H_
#define _MACHINE_PTHREAD_VAR_H_

/* really only need <sp,pc> as fp is stored in stack, but this is easier */
#define	_THREAD_SPARC_PC	0
#define _THREAD_SPARC_SP	1
#define	_THREAD_SPARC_FP	2
#define	_THREAD_SPARC_DOFLOAT	3	/* ??? (psr) */
#define	_THREAD_SPARC_NREGS	4

#define	_THREAD_SPARC_FPU	32	/* 32 %fNN + %fsr */

struct _thread_sparc_state {
	unsigned int regs[_THREAD_SPARC_NREGS];
	unsigned long long saved_fp[_THREAD_SPARC_FPU / 2];
	unsigned int saved_fsr;
};

typedef struct _thread_sparc_state thread_machdep_state;

#endif	/* _MACHINE_PTHREAD_VAR_H_ */
