/*	BSDI bootp.h,v 2.5 2001/03/01 03:57:43 prb Exp	*/

/* @(#) =Header: bootp.h,v 1.1 92/09/11 01:15:54 leres Exp = (LBL) */
/*
 * Bootstrap Protocol (BOOTP).  RFC951 and RFC1048.
 *
 * This file specifies the "implementation-independent" BOOTP protocol
 * information which is common to both client and server.
 *
 * Copyright 1988 by Carnegie Mellon.
 *
 * Permission to use, copy, modify, and distribute this program for any
 * purpose and without fee is hereby granted, provided that this copyright
 * and permission notice appear on all copies and supporting documentation,
 * the name of Carnegie Mellon not be used in advertising or publicity
 * pertaining to distribution of the program without specific prior
 * permission, and notice be given in supporting documentation that copying
 * and distribution is by permission of Carnegie Mellon and Stanford
 * University.  Carnegie Mellon makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 */


#ifndef _STAND_BOOTP_H_
#define _STAND_BOOTP_H_

/*
 * Make sure there's room in a BOOTP packet for all the parameters we want.
 */
#define	BOOTP_PACKET_SIZE	1500

struct bootp {
	u_int8_t	bp_op;		/* packet opcode type */
	u_int8_t	bp_htype;	/* hardware addr type */
	u_int8_t	bp_hlen;	/* hardware addr length */
	u_int8_t	bp_hops;	/* gateway hops */
	u_int32_t	bp_xid;		/* transaction ID */
	u_int16_t	bp_secs;	/* seconds since boot began */
	u_int16_t	bp_unused;
	struct in_addr	bp_ciaddr;	/* client IP address */
	struct in_addr	bp_yiaddr;	/* 'your' IP address */
	struct in_addr	bp_siaddr;	/* server IP address */
	struct in_addr	bp_giaddr;	/* gateway IP address */
	u_int8_t	bp_chaddr[16];	/* client hardware address */
	u_int8_t	bp_sname[64];	/* server host name */
	u_int8_t	bp_file[128];	/* boot file name */
	u_int8_t	bp_vend[64];	/* vendor-specific area */
};

/*
 * UDP port numbers, server and client.
 */
#define	IPPORT_BOOTPS		67
#define	IPPORT_BOOTPC		68

#define BOOTREQUEST		1
#define BOOTREPLY		2

/*
 * Hardware types from Assigned Numbers RFC.
 */
#define HTYPE_ETHERNET		  1
#define HTYPE_EXP_ETHERNET	  2
#define HTYPE_AX25		  3
#define HTYPE_PRONET		  4
#define HTYPE_CHAOS		  5
#define HTYPE_IEEE802		  6
#define HTYPE_ARCNET		  7

/*
 * Vendor magic cookie (v_magic) for RFC1048
 */
#define VM_RFC1048	{ 99, 130, 83, 99 }

/*
 * RFC1048 tag values used to specify what information is being supplied in
 * the vendor field of the packet.
 */

/* RFC 1048 */
#define TAG_END			((u_int8_t) 255)
#define TAG_PAD			((u_int8_t)   0)
#define TAG_SUBNET_MASK		((u_int8_t)   1)
#define TAG_TIME_OFFSET		((u_int8_t)   2)
#define TAG_GATEWAY		((u_int8_t)   3)
#define TAG_TIME_SERVER		((u_int8_t)   4)
#define TAG_NAME_SERVER		((u_int8_t)   5)
#define TAG_DOMAIN_SERVER	((u_int8_t)   6)
#define TAG_LOG_SERVER		((u_int8_t)   7)
#define TAG_COOKIE_SERVER	((u_int8_t)   8)
#define TAG_LPR_SERVER		((u_int8_t)   9)
#define TAG_IMPRESS_SERVER	((u_int8_t)  10)
#define TAG_RLP_SERVER		((u_int8_t)  11)
#define TAG_HOST_NAME		((u_int8_t)  12)
#define TAG_BOOT_SIZE		((u_int8_t)  13)
/* RFC 1395 */
#define TAG_DUMP_FILE		((u_int8_t)  14)
#define TAG_DOMAIN_NAME		((u_int8_t)  15)
#define TAG_SWAP_SERVER		((u_int8_t)  16)
#define TAG_ROOT_PATH		((u_int8_t)  17)
/* RFC 1497 */
#define TAG_EXTEN_FILE		((u_int8_t)  18)
/* RFC 1533 */
#define TAG_NIS_DOMAIN		((u_int8_t)  40)
#define TAG_NIS_SERVER		((u_int8_t)  41)
#define TAG_NTP_SERVER		((u_int8_t)  42)
#define	TAG_VENDOR_OPTIONS	((u_int8_t)  43)
/* DHCP */
#define TAG_REQUESTED_ADDRESS	((u_int8_t)  50)
#define TAG_LEASE_TIME		((u_int8_t)  51)
#define TAG_DHCP_MESSAGE_TYPE	((u_int8_t)  53)
#define TAG_SERVER_IDENTIFIER	((u_int8_t)  54)
#define TAG_MAX_MSGSZ		((u_int8_t)  57)
#define	TAG_CLASS_IDENTIFIER	((u_int8_t)  60)

/*
 * BSDi class tags
 */
#define	BSDi_BOOTDEFINE		((u_int8_t)  1)
#define	BSDi_BOOTDEFAULT	((u_int8_t)  2)


/* DHCP message types. */
#define DHCPDISCOVER    1
#define DHCPOFFER       2
#define DHCPREQUEST     3
#define DHCPDECLINE     4
#define DHCPACK         5
#define DHCPNAK         6
#define DHCPRELEASE     7
#define DHCPINFORM      8

#define	LEASE_TIME	300	/* Default to 300 seconds */

#endif /* !_STAND_BOOTP_H_ */
