/*-
 * Copyright (c) 1998 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI $Id: flash.h,v 1.1.10.2 2001/07/13 04:05:31 prb Exp $
 */

/*
 * Areas we can write into
 *
 * Config segments must map 0 -> 0 and 1 -> 1
 */
#define	FL_CONFIG0	0
#define	FL_CONFIG1	1
#define	FL_FULLPART	2
#define	FL_BOOTAREA	3
#define	FL_USERAREA	4
#define	FL_RAWPART	5

#define	FL_MAXAREAS	6

typedef struct flash_t {
	void	*private;

	u_long	areasize[FL_MAXAREAS];
	u_long	areaoffset[FL_MAXAREAS];

	u_long	erasesize;	/* erasable block size, in bytes */
	u_long	writesize;	/* write size, in bytes */
	u_long	flags;		/* mode flags */

	int	(*read)(struct flash_t *, u_long, void *, long, int);
	int	(*write)(struct flash_t *, u_long, void *, long, int);
	int	(*erase)(struct flash_t *, u_long, long, int);
	void	(*display)(struct flash_t *);
	void	(*free)(struct flash_t *);
	int	(*control)(struct flash_t *, int, void *);
} flash_t;

#define	FL_SIZE(f)	((f)->areasize[FL_FULLPART])
#define	FL_END(f, a)	((f)->areaoffset[a] + (f)->areasize[a])

#define	FL_EXTRA	0x0002	/* Use extra segment, if it exists */
#define	FL_HASECC	0x0004	/* This device does ECC */

#define	FL_BADBLOCK	0x0001	/* Identify a bad block */
#define	FL_INITIALIZE	0x0002	/* Initialize the flash device */
#define	FL_INSTALLBOOT	0x0004	/* Install a boot record */

typedef struct {
	long		badblock;
	int		area;
} FL_BADBLOCK_args;

typedef struct {
	char		*xxboot;
	char		*bootxx;
	char		*mbr;
	u_long		configsize;
} FL_INSTALLBOOT_args;
