/*	BSDI net.h,v 2.6 2001/03/01 04:00:00 prb Exp	*/

/*
 * Copyright (c) 1992, 1993, 1994
 *	Regents of the University of California.  All rights reserved.
 *
 * This software was developed by the Computer Systems Engineering group
 * at Lawrence Berkeley Laboratory under DARPA contract BG 91-66 and
 * contributed to Berkeley.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Lawrence Berkeley Laboratory and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * @(#) =Header: bootbootp.h,v 1.9 94/01/12 20:28:22 leres Exp = (LBL)
 */

#ifndef _STAND_NET_H_
#define _STAND_NET_H_

/*
 * Common definitions for net-related standalone routines.
 */

#define BA { 0xff, 0xff, 0xff, 0xff, 0xff, 0xff }

/* Returns true if n_long's on the same net */
#define	SAMENET(a1, a2, m) ((a1 & m) == (a2 & m))

#define MAXTMO			60	/* seconds */
#define MINTMO			2	/* seconds */

#define FNAME_SIZE		128
#define	IFNAME_SIZE		16
#define RECV_SIZE		1536	/* XXX delete this */
#define	MAXNFSXFER		8192

/* Size of struct ether_header + struct ip + struct udphdr */
#define ETHER_SIZE		14
#define	HEADER_SIZE		(ETHER_SIZE + 20 + 8)

/* XXX compat */
#define	NFS_FHSIZE	NFSX_V2FH	/* ??? */
/* #define NFS_FHSIZE	NFSX_V3FHMAX	-- not yet */

struct iodesc {
	struct	open_file *fd;		/* the current file */
	u_char	destea[6];		/* destination ethernet address */
	n_long	destip;			/* destination ip address */
	u_int16_t destport;		/* destination port */
	u_int16_t myport;		/* destination port */
	u_int32_t xid;			/* transaction identification */
	u_char	*fh;			/* pointer to file handle */
	u_long	offset;			/* seek pointer */
	u_long	size;			/* cached length of file */
	int	timeout;		/* how long this operation can go on */
};

extern	u_char bcea[6];
extern	u_char myea[6];

/* ### most of the following should just be an nfs_diskless structure? */
extern	char rootpath[MAXPATHLEN];
extern	char swappath[MAXPATHLEN];

extern	char myhostname[MAXHOSTNAMELEN];
extern	char roothostname[MAXHOSTNAMELEN];
extern	char swaphostname[MAXHOSTNAMELEN];

extern	char ifname[IFNAME_SIZE];

extern	u_char rootfh[NFS_FHSIZE];
extern	u_char swapfh[NFS_FHSIZE];

extern	n_long myip;
extern	n_long rootip;
extern	n_long swapip;
extern	n_long gateip;
extern	n_long routerip;
extern	n_long subnetmask;

extern	u_long swapblks;
extern	time_t roottime;

int	bootp __P((struct iodesc *));
void	diskless_setup __P((void));

u_char	*arpwhohas __P((struct iodesc *, n_long));

int	getnfsfh __P((struct iodesc *, char *, u_char *));
int	getnfsinfo __P((struct iodesc *, time_t *, u_long *, u_long *));
int	lookupfh __P((struct iodesc *, char *, u_char *, time_t *,
	    u_long *, u_long *));
int	readdata __P((struct iodesc *, u_long, void *, u_long));

int	ethernet_put __P((struct iodesc *, void *, int));
int	ethernet_get __P((struct iodesc *, void *, int, time_t));

int	sendether __P((struct iodesc *, void *, int, u_char *, int));
int	sendudp __P((struct iodesc *, void *, int));
int	recvudp __P((struct iodesc *, void *, int, time_t));
int	sendrecv __P((struct iodesc *, int (*)(struct iodesc *, void *, int),
	    void *, int, int (*)(struct iodesc *, void *, int), void *, int));
void	*checkudp __P((struct iodesc *, void *, int *));

int	in_cksum __P((void *, int));

time_t	getsecs __P((void));

#endif /* !_STAND_NET_H_ */
