/*-
 * Copyright (c) 1997 Berkeley Software Design, Inc.
 *
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI romfs.h,v 2.4 1999/07/23 02:33:34 prb Exp
 */

#define	RF_MAGIC	"RFS0"
/*
 * Round x to a long word boundry
 */
#define	LWROUND(x)	(((x) + sizeof(long) - 1) & ~(sizeof(long) - 1))

/*
 * Each file is preceeded by an rfnode_t structure.
 * The next rfnode_t structure is located at RFNEXTNODE(&rfn)
 * Nodes are always stored on long word boundries
 */
typedef struct rfnode_t {
	u_int32_t	rf_size;
	u_int16_t	rf_mode;
	int16_t		rf_nlink;
	struct timespec rf_ctime;
	u_int32_t	rf_flags;
	u_int32_t	rf_uid;
	u_int32_t	rf_gid;
	u_int32_t	rf_rdev;

	/*
	 * The entries below are not stored in the filesystem.
	 * but are computed when the rfnode_t block is read
	 */
	u_int32_t	rf_offset;	/* Offset into device */
	u_int32_t	rf_seekp;	/* Our current seek pointer */
#if	defined(KERNEL) && !defined(STANDALONE)
        struct lock	rf_lock;	/* node lock */
	dev_t		rf_dev;		/* Device where inode resides */
	struct vnode	*rf_vnode;	/* Back pointer to the vnode */
	struct vnode	*rf_devvp;	/* Back pointer to the device vnode */
	struct rfnode_t	*rf_next;
	struct rfnode_t	**rf_prev;
#endif
} rfnode_t;

#define VTOI(vp) ((struct rfnode_t *)(vp)->v_data)
#define ITOV(ip) ((ip)->rf_vnode)

#define	RFNODESZ ((char *)(&(((rfnode_t *)0)->rf_offset)) - (char *)0)

/*
 * Given a pointer to an rfnode_t read from the filesystem, return a pointer
 * to the next file
 */
#define RFNEXTNODE(rfp)	LWROUND((rfp)->rf_offset + RFNODESZ + (rfp)->rf_size)

/*
 * Names are up to 255 bytes long
 * The actual structure is truncated to the lowest long word boundry which
 * allows the entire name to be stored.
 */
typedef struct {
	u_int32_t	rd_offset;
	u_char		rd_namelen;
	char		rd_name[255];
} rfdir_t;

/*
 * Given a pointer to an rfdir_t entry return the offset of the next rfdir_t
 * entry.  In the current director.  Note that an offset of 0 implies the
 * end of the directory and all other fields are invalid.
 */
#define	RFDIRSZ(n) LWROUND(((char *)(&(((rfdir_t *)0)->rd_name[strlen(n)])) - (char *)0))
#define	RFNDIRSZ(n) LWROUND(((char *)(&(((rfdir_t *)0)->rd_name[n])) - (char *)0))
#define RFNEXTDIR(rfp, rdp)	LWROUND((rfp)->rf_offset + (rdp)->rd_offset)


#if defined(STANDALONE)
int rfs_open __P((char *, struct open_file *));
int rfs_read __P((struct open_file *, char *, u_int, u_int *));
off_t rfs_seek __P((struct open_file *, off_t, int));
#ifndef SMALL
int rfs_close __P((struct open_file *));
int rfs_write __P((struct open_file *, char *, u_int, u_int *));
int rfs_stat __P((struct open_file *, struct stat *));
int rfs_ls __P((struct open_file *));
#endif
#endif
