/*	BSDI conf.h,v 2.9.2.1 2001/05/11 16:15:47 karels Exp	*/

/*-
 * Copyright (c) 1990, 1993
 *	The Regents of the University of California.  All rights reserved.
 * (c) UNIX System Laboratories, Inc.
 * All or some portions of this file are derived from material licensed
 * to the University of California by American Telephone and Telegraph
 * Co. or Unix System Laboratories, Inc. and are reproduced herein with
 * the permission of UNIX System Laboratories, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)conf.h	8.5 (Berkeley) 1/9/95
 */

#ifndef _SYS_CONF_H_
#define _SYS_CONF_H_

/*
 * Definitions of device driver entry switches
 */

#ifdef __STDC__
struct buf;
struct proc;
struct tty;
struct uio;
struct vnode;
#endif

/* Combined block/char driver data, initialized in each driver. */
struct devsw {
	/* Direct access to units via d_cd->cd_devs (???) */
	struct	cfdriver	*d_cd;

	/* System calls. */
	int	(*d_open)	__P((dev_t dev, int oflags, int devtype,
				     struct proc *p));
	int	(*d_close)	__P((dev_t dev, int fflag, int devtype,
				     struct proc *));
	int	(*d_read)	__P((dev_t dev, struct uio *uio, int ioflag));
	int	(*d_write)	__P((dev_t dev, struct uio *uio, int ioflag));
	int	(*d_ioctl)	__P((dev_t dev, u_long cmd, caddr_t data,
				     int fflag, struct proc *p));
	int	(*d_select)	__P((dev_t dev, int which, struct proc *p));
	vm_offset_t
		(*d_mmap)	__P((dev_t dev, int off, int prot));

	/* Structured interfaces (disk/tape only, really). */
	void	(*d_strategy)	__P((struct buf *bp));
	int	(*d_dump)	__P((dev_t dev, daddr_t blkoff, caddr_t addr,
				     int len));
	int	(*d_psize)	__P((dev_t dev));

#define	D_TAPE	1
#define	D_DISK	2
#define	D_TTY	3
	int	d_type;

	/* Other structured interfaces.  XXX: should be redone. */
	void	(*d_stop)	__P((struct tty *tp, int rw));

	/* fast select init; at end for now so not all drivers need change */
	int	(*d_selinit)	__P((dev_t, struct proc *, int));
};

#ifdef KERNEL
extern struct devsw *devsw[];
extern int ndevsw;

int	rawread		__P((dev_t, struct uio *, int));
int	rawwrite	__P((dev_t, struct uio *, int));

/* defines suitable for use in drivers */
#define	noopen	 ((int (*) __P((dev_t, int, int, struct proc *)))enodev)
#define	noclose	 ((int (*) __P((dev_t, int, int, struct proc *)))enodev)
#define	noread	 ((int (*) __P((dev_t, struct uio *, int)))enodev)
#define	nowrite	 ((int (*) __P((dev_t, struct uio *, int)))enodev)
#define	noioctl	 \
	((int (*) __P((dev_t, u_long, caddr_t, int, struct proc *)))enoioctl)
#define	noselect ((int (*) __P((dev_t, int, struct proc *)))enodev)
#define	nommap	 0
#define	nostrat	 0
#define	nodump	 ((int (*) __P((dev_t, daddr_t, caddr_t, int)))enodev)
#define	nopsize	 0
#define	nostop	 ((void (*) __P((struct tty *tp, int)))nullop)

#define	nullopen  ((int (*) __P((dev_t, int, int, struct proc *)))nullop)
#define	nullclose ((int (*) __P((dev_t, int, int, struct proc *)))nullop)
#define	nullioctl \
	((int (*) __P((dev_t, int, caddr_t, int, struct proc *)))nullop)
#define	nullstop  ((void (*) __P((struct tty *, int)))nullop)

/* symbolic sleep message strings */
extern char devopn[], devio[], devwait[], devin[], devout[];
extern char devioc[], devcls[];
#endif

struct linesw {
	int	(*l_open)	__P((dev_t dev, struct tty *tp));
	int	(*l_close)	__P((struct tty *tp, int flag));
	int	(*l_read)	__P((struct tty *tp, struct uio *uio,
				     int flag));
	int	(*l_write)	__P((struct tty *tp, struct uio *uio,
				     int flag));
	int	(*l_ioctl)	__P((struct tty *tp, u_long cmd, caddr_t data,
				     int flag, struct proc *p));
	void	(*l_rint)	__P((int c, struct tty *tp));
	int	(*l_start)	__P((struct tty *tp));
	int	(*l_modem)	__P((struct tty *tp, int flag));
};

#ifdef KERNEL
extern struct linesw linesw[];
#endif

struct swdevt {
	dev_t	sw_dev;
	int	sw_flags;
	int	sw_nblks;
	struct	vnode *sw_vp;
	struct	swdevt *sw_next;
};
#define	SW_FREED	0x01
#define	SW_SEQUENTIAL	0x02
#define sw_freed	sw_flags	/* XXX compat */

#ifdef KERNEL
extern struct swdevt swdevt[];
#endif

#endif /* !_SYS_CONF_H_ */
