/*-
 * Copyright (c) 1996 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *      BSDI ktr.h,v 1.14.4.2 2001/06/11 15:20:23 dab Exp
 */

/*
 *	Wraparound kernel trace buffer support.
 */

#ifndef _SYS_KTR_H_
#define _SYS_KTR_H_


/* Requires sys/types.h and sys/time.h */

#define	KTR_ESIZE	32		/* Size of 1 entry (ust be ^2) */
#define	KTR_SHFT	5		/* log2(KTR_ESIZE) */

/*
 * Trace classes
 */
#define	KTR_GEN		0x000001		/* General (TR) */
#define	KTR_INTR	0x000002		/* Interrupt tracing */
#define	KTR_IO		0x000004		/* Upper I/O  */
#define	KTR_FS		0x000008		/* Filesystem */
#define	KTR_NET		0x000010		/* Network */
#define	KTR_DEV		0x000020		/* Device driver */
#define	KTR_PROC	0x000040		/* Process scheduling */
#define	KTR_SYSC	0x000080		/* System call */
#define	KTR_HWBP	0x001000		/* Hardware breakpoints */
#define	KTR_TRAP	0x002000		/* Trap processing */
#define	KTR_SPL		0x004000		/* trace spl calls */
#define	KTR_SMP		0x008000		/* MP general */
#define	KTR_CLK		0x010000		/* hardclock verbose */
#define	KTR_LOCK	0x020000		/* MP locking */
#define KTR_SIG		0x040000		/* Signal processing */
#define KTR_PMAP	0x080000		/* Pmap tracing */

/* Trace classes to compile in */
#ifndef KTR_COMPILE
#define	KTR_COMPILE	~(KTR_SPL|KTR_DEV)
#endif

#ifndef LOCORE

#include <sys/time.h>

#ifdef KERNEL
extern struct timeval time;
#endif

struct ktr_entry {
	union {
		struct	timeval ktr_tv;
		u_quad_t ktr_clk;
	} u;
	char	*ktr_desc;
	u_long	ktr_parm1;
	u_long	ktr_parm2;
	u_long	ktr_parm3;
	u_long	ktr_parm4;
	u_long	ktr_parm5;
};

extern int ktr_mask;
extern int ktr_size;
extern int ktr_size_mask;

/* Sanity checks: update KTR_ESIZE and KTR_SHFT if this fails to compile */
typedef	int __ktr_dummy1[1 / (sizeof(struct ktr_entry) == KTR_ESIZE)];
typedef	int __ktr_dummy2[1 / (sizeof(struct ktr_entry) == 1 << KTR_SHFT)];

#endif /* !LOCORE */
#ifdef KTR

#include <machine/ktr.h>

#ifndef KTR_SIZE
#define	KTR_SIZE	8192
#endif

#ifndef _TR
#define _TR(_desc) 						\
	volatile struct ktr_entry *_ktrptr;			\
	int _idx;						\
	_idx = PCPU(pc_ktr_idx);				\
	_idx += sizeof(struct ktr_entry);			\
	_idx &= ktr_size_mask;					\
	SET_PCPU(pc_ktr_idx, _idx);				\
	_ktrptr = (struct ktr_entry *)(PCPU(pc_ktr_buf) + _idx);	\
	_ktrptr->ktr_tv.tv_sec = time.tv_sec;			\
	_ktrptr->ktr_tv.tv_usec = time.tv_usec;			\
	_ktrptr->ktr_desc = (_desc);
#endif

#define	TR0(_desc) 						\
do {								\
	if (KTR_COMPILE & KTR_GEN) {				\
		if (ktr_mask & KTR_GEN) {			\
			_TR(_desc)				\
		}						\
	}							\
} while (0)
#define	TR1(_desc, _p1)						\
do {								\
	if (KTR_COMPILE & KTR_GEN) {				\
		if (ktr_mask & KTR_GEN) {			\
			_TR(_desc)				\
			_ktrptr->ktr_parm1 = (u_long)(_p1);	\
		}						\
	}							\
} while (0)
#define	TR2(_desc, _p1, _p2)					\
do {								\
	if (KTR_COMPILE & KTR_GEN) {				\
		if (ktr_mask & KTR_GEN) {			\
			_TR(_desc)				\
			_ktrptr->ktr_parm1 = (u_long)(_p1);	\
			_ktrptr->ktr_parm2 = (u_long)(_p2);	\
		}						\
	}							\
} while (0)
#define	TR3(_desc, _p1, _p2, _p3)				\
do {								\
	if (KTR_COMPILE & KTR_GEN) {				\
		if (ktr_mask & KTR_GEN) {			\
			_TR(_desc)				\
			_ktrptr->ktr_parm1 = (u_long)(_p1);	\
			_ktrptr->ktr_parm2 = (u_long)(_p2);	\
			_ktrptr->ktr_parm3 = (u_long)(_p3);	\
		}						\
	}							\
} while (0)
#define	TR4(_desc, _p1, _p2, _p3, _p4)				\
do {								\
	if (KTR_COMPILE & KTR_GEN) {				\
		if (ktr_mask & KTR_GEN) {			\
			_TR(_desc)				\
			_ktrptr->ktr_parm1 = (u_long)(_p1);	\
			_ktrptr->ktr_parm2 = (u_long)(_p2);	\
			_ktrptr->ktr_parm3 = (u_long)(_p3);	\
			_ktrptr->ktr_parm4 = (u_long)(_p4);	\
		}						\
	}							\
} while (0)
#define	TR5(_desc, _p1, _p2, _p3, _p4, _p5)			\
do {								\
	if (KTR_COMPILE & KTR_GEN) {				\
		if (ktr_mask & KTR_GEN) {			\
			_TR(_desc)				\
			_ktrptr->ktr_parm1 = (u_long)(_p1);	\
			_ktrptr->ktr_parm2 = (u_long)(_p2);	\
			_ktrptr->ktr_parm3 = (u_long)(_p3);	\
			_ktrptr->ktr_parm4 = (u_long)(_p4);	\
			_ktrptr->ktr_parm5 = (u_long)(_p5);	\
		}						\
	}							\
} while (0)
#define	CTR0(m, _desc) 						\
do {								\
	if (KTR_COMPILE & m) {					\
		if (ktr_mask & (m)) {				\
			_TR(_desc)				\
		}						\
	}							\
} while (0)
#define	CTR1(m, _desc, _p1)					\
do {								\
	if (KTR_COMPILE & m) {					\
		if (ktr_mask & (m)) {				\
			_TR(_desc)				\
			_ktrptr->ktr_parm1 = (u_long)(_p1);	\
		}						\
	}							\
} while (0)
#define	CTR2(m, _desc, _p1, _p2) 				\
do {								\
	if (KTR_COMPILE & m) {					\
		if (ktr_mask & (m)) {				\
			_TR(_desc)				\
			_ktrptr->ktr_parm1 = (u_long)(_p1);	\
			_ktrptr->ktr_parm2 = (u_long)(_p2);	\
		}						\
	}							\
} while (0)
#define	CTR3(m, _desc, _p1, _p2, _p3) 				\
do {								\
	if (KTR_COMPILE & m) {					\
		if (ktr_mask & (m)) {				\
			_TR(_desc)				\
			_ktrptr->ktr_parm1 = (u_long)(_p1);	\
			_ktrptr->ktr_parm2 = (u_long)(_p2);	\
			_ktrptr->ktr_parm3 = (u_long)(_p3);	\
		}						\
	}							\
} while (0)
#define	CTR4(m, _desc, _p1, _p2, _p3, _p4) 			\
do {								\
	if (KTR_COMPILE & m) {					\
		if (ktr_mask & (m)) {				\
			_TR(_desc)				\
			_ktrptr->ktr_parm1 = (u_long)(_p1);	\
			_ktrptr->ktr_parm2 = (u_long)(_p2);	\
			_ktrptr->ktr_parm3 = (u_long)(_p3);	\
			_ktrptr->ktr_parm4 = (u_long)(_p4);	\
		}						\
	}							\
} while (0)
#define	CTR5(m, _desc, _p1, _p2, _p3, _p4, _p5) 		\
do {								\
	if (KTR_COMPILE & m) {					\
		if (ktr_mask & (m)) {				\
			_TR(_desc)				\
			_ktrptr->ktr_parm1 = (u_long)(_p1);	\
			_ktrptr->ktr_parm2 = (u_long)(_p2);	\
			_ktrptr->ktr_parm3 = (u_long)(_p3);	\
			_ktrptr->ktr_parm4 = (u_long)(_p4);	\
			_ktrptr->ktr_parm5 = (u_long)(_p5);	\
		}						\
	}							\
} while (0)

#else	/* KTR */
#undef KTR_COMPILE
#define KTR_COMPILE 0
#define	TR0(d)
#define	TR1(d, p1)
#define	TR2(d, p1, p2)
#define	TR3(d, p1, p2, p3)
#define	TR4(d, p1, p2, p3, p4)
#define	TR5(d, p1, p2, p3, p4, p5)
#define	CTR0(m, d)
#define	CTR1(m, d, p1)
#define	CTR2(m, d, p1, p2)
#define	CTR3(m, d, p1, p2, p3)
#define	CTR4(m, d, p1, p2, p3, p4)
#define	CTR5(m, d, p1, p2, p3, p4, p5)
#define	SEG_ATR(d,s)
#define	SEG_ATR_DESC(d,s)
#define	ATR(d)
#define	CATR(f,d,n)
#define	CATRD(f,d,n)
#ifdef KTR_SIZE
#undef KTR_SIZE
#endif
#define	KTR_SIZE 0		/* For binary kernels */
#endif	/* KTR */

#endif /* !_SYS_KTR_H_ */
