/*-
 * Copyright (c) 1996 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI select.h,v 2.8 2001/03/06 16:22:34 giff Exp
 */

/*-
 * Copyright (c) 1992, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)select.h	8.2 (Berkeley) 1/4/94
 */

#ifndef _SYS_SELECT_H_
#define	_SYS_SELECT_H_

#include <sys/types.h>

/*
 * Select uses bit masks of file descriptors in longs.  These macros
 * manipulate such bit fields (the filesystem macros use chars).
 * FD_SETSIZE may be defined by the user, but the default here should
 * be enough for most uses.
 */
#ifndef	FD_SETSIZE
#define	FD_SETSIZE	1024
#endif

typedef long	fd_mask;
#define NFDBITS	(sizeof(fd_mask) * NBBY)	/* bits per mask */

typedef	struct fd_set {
	fd_mask	fds_bits[__howmany(FD_SETSIZE, NFDBITS)];
} fd_set;

#define	FD_SET(n, p)	((p)->fds_bits[(n)/NFDBITS] |= (1 << ((n) % NFDBITS)))
#define	FD_CLR(n, p)	((p)->fds_bits[(n)/NFDBITS] &= ~(1 << ((n) % NFDBITS)))
#define	FD_ISSET(n, p)	((p)->fds_bits[(n)/NFDBITS] & (1 << ((n) % NFDBITS)))
#define	FD_ZERO(p)	memset((p), 0, sizeof(*(p)))

#ifndef _POSIX_SOURCE	/* Need  to correct for POSIX.1g */
#define	FD_COPY(f, t)	memcpy((t), (f), sizeof(*(f)))

/*
 * FD_ALLOC allocates an fd_set sufficient for the specified number of
 * descriptors.  It can be freed with free().  The FD_ZERO and FD_COPY
 * macros cannot be used with these fd_sets; use FD_NZERO and FD_NCOPY.
 *
 * FD_REALLOC reallocs an fd_set allocated by FD_ALLOC, given a pointer
 * to the set, and the old and new number of descriptors.
 */
#define	FD_ALLOC(n) ((fd_set *)calloc(sizeof(fd_mask), __howmany((n), NFDBITS)))
#define	FD_REALLOC(fdset, oldn, newn)	__fd_realloc((fdset), (oldn), (newn))

/* The following work on variable-sized fd_sets */
#define	FD_NZERO(n, p) \
	memset((p), 0, sizeof(fd_mask) * __howmany((n), NFDBITS))
#define	FD_NCOPY(n, f, t) \
	memcpy((t), (f), sizeof(fd_mask) * __howmany((n), NFDBITS))

/* Kernel internals for select. */

/*
 * Used to maintain information about processes that wish to be notified when
 * I/O becomes possible.
 */
struct selinfo {
	pid_t	si_pid;		/* process to be notified */
	short	si_flags;	/* see below */
};
#define	SI_COLL	0x0001		/* collision occurred */

#ifdef KERNEL
struct proc;

void	selrecord __P((struct proc *selector, struct selinfo *));

/* wakeup a selecting proc */
#define	selwakeup(si) { \
	if ((si)->si_pid) \
		_selwakeup(si); \
}

void	_selwakeup __P((struct selinfo *));
#endif /* KERNEL */
#endif /* !_POSIX_SOURCE */

#ifndef KERNEL
#include <sys/signaltypes.h>
#include <sys/cdefs.h>

__BEGIN_DECLS
struct timeval;
struct timespec;
int	select __P((int, fd_set *, fd_set *, fd_set *, const struct timeval *));

int	pselect __P((int, fd_set *, fd_set *, fd_set *,
	    const struct timespec *, const sigset_t *));
__END_DECLS
#endif /* !KERNEL */
#endif /* !_SYS_SELECT_H_ */
