/*-
 * Copyright (c) 1993, 1995, 1997 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI sfork.h,v 1.3 2000/09/15 15:43:28 donn Exp
 */

#ifndef _SYS_SFORK_H_
#define _SYS_SFORK_H_

/*
 * Values for sfork "share" mask
 */
#define	SF_MEM		0x01		/* share address space */
#define	SF_CRED		0x02		/* share process credentials */
#define	SF_DESCRIP	0x04		/* share descriptors, cur dir, etc */
#define	SF_RLIM		0x08		/* share resource limits */
#define	SF_SIG		0x10		/* share sigaction state */

#define	SF_SHARE_ALL	(SF_MEM | SF_CRED | SF_DESCRIP | SF_RLIM | SF_SIG)

/* the following not yet implemented */
#define	SF_STATS	0x00		/* share resource util/statistics */
#define	SF_SCHED	0x00		/* share scheduling stats/parms */
#define	SF_PID		0x00		/* share process ID, for pthreads */

/*
 * Values for non-sharing sfork flags
 */
#define	SF_WAITCHILD	0x80000000	/* parent waits for child ala vfork */

#ifndef KERNEL
#ifndef LOCORE
#include <sys/cdefs.h>

__BEGIN_DECLS
int	sfork __P((int, void *, int));
__END_DECLS
#endif
#endif

#endif /* !_SYS_SFORK_H_ */
