/*	BSDI types.h,v 2.6 2000/06/08 20:10:46 prb Exp	*/

/*-
 * Copyright (c) 1982, 1986, 1991, 1993, 1994
 *	The Regents of the University of California.  All rights reserved.
 * (c) UNIX System Laboratories, Inc.
 * All or some portions of this file are derived from material licensed
 * to the University of California by American Telephone and Telegraph
 * Co. or Unix System Laboratories, Inc. and are reproduced herein with
 * the permission of UNIX System Laboratories, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)types.h	8.6 (Berkeley) 2/19/95
 */

#ifndef _SYS_TYPES_H_
#define	_SYS_TYPES_H_

/* Machine type dependent parameters. */
#include <machine/ansi.h>
#include <machine/types.h>

#ifndef _POSIX_SOURCE
typedef	unsigned long	u_long;
typedef	unsigned int	u_int;
typedef	unsigned short	u_short;
typedef	unsigned char	u_char;
typedef	unsigned int	uint;		/* Sys V compatibility */
typedef	unsigned short	ushort;		/* Sys V compatibility */
#endif

typedef	u_int64_t	u_quad_t;	/* quads */
typedef	int64_t		quad_t;
typedef	quad_t *	qaddr_t;

typedef struct {
        u_int8_t data[16];
} q128_t;

/*
 * Some of the following should probably be moved to <machine/types.h> because
 * of machine-dependent compatibility and/or efficiency considerations.
 */
typedef	char *		caddr_t;	/* core address */
typedef	long		daddr_t;	/* disk address */
typedef	unsigned long	dev_t;		/* device number */
typedef unsigned long	fixpt_t;	/* fixed point number */
typedef	unsigned int	gid_t;		/* group id */
typedef	unsigned long	ino_t;		/* inode number */
typedef	long		key_t;		/* IPC key (for Sys V IPC) */
typedef	u_int16m_t	mode_t;		/* permissions */
typedef	u_int16m_t	nlink_t;	/* link count */
typedef	quad_t		off_t;		/* file offset */
typedef	int		pid_t;		/* process id */
typedef	long		segsz_t;	/* segment size */
typedef	long		swblk_t;	/* swap offset */
typedef	unsigned int	uid_t;		/* user id */

/*
 * The prototype for lseek() belongs in unistd.h, but is placed here
 * to maximize the likelihood that the offset will correctly be passed
 * as an off_t.
 */
#if	!defined(KERNEL) && !defined(STANDALONE)
#include <sys/cdefs.h>
__BEGIN_DECLS
off_t	 lseek __P((int, off_t, int));
__END_DECLS
#endif

#ifndef _POSIX_SOURCE
#define	major(x)	((int)(((u_int)(x) >> 20) & 0xfff))
#define	minor(x)	((int)((x) & 0xfffff))		/* minor number */
#define	makedev(x,y)	((dev_t)(((x) << 20) | (y)))	/* create dev_t */
#define	dv_unit(x)	((int)(((x) >> 10) & 0x3ff))	/* unit number */
#define	dv_subunit(x)	((int)((x) & 0x3ff))		/* subunit number */
#define	dv_makedev(x,y,z)	((dev_t)(((x)<<20) | ((y) << 10) | (z)))
#endif

#include <machine/endian.h>

#ifdef	_BSD_CLOCK_T_
typedef	_BSD_CLOCK_T_	clock_t;
#undef	_BSD_CLOCK_T_
#endif

#ifdef	_BSD_SIZE_T_
typedef	_BSD_SIZE_T_	size_t;
#undef	_BSD_SIZE_T_
#endif

#ifdef	_BSD_SSIZE_T_
typedef	_BSD_SSIZE_T_	ssize_t;
#undef	_BSD_SSIZE_T_
#endif

#ifdef	_BSD_TIME_T_
typedef	_BSD_TIME_T_	time_t;
#undef	_BSD_TIME_T_
#endif

#ifndef __howmany
#define	__howmany(x, y)	(((x) + ((y) - 1)) / (y))
#endif

#ifndef _POSIX_SOURCE
#define	NBBY	8		/* number of bits in a byte */

#ifndef howmany
#define	howmany(x, y)	__howmany((x), (y))
#endif

#include <sys/select.h>

#if defined(__STDC__) && defined(KERNEL)
/*
 * Forward structure declarations for function prototypes.  We include the
 * common structures that cross subsystem boundaries here; others are mostly
 * used in the same place that the structure is defined.
 */
struct	proc;
struct	pgrp;
struct	ucred;
struct	rusage;
struct	file;
struct	buf;
struct	tty;
struct	uio;
#endif

#endif /* !_POSIX_SOURCE */
#endif /* !_SYS_TYPES_H_ */
