#ifdef __cplusplus
extern "C" {
#endif
/*
 *		AIX/370
 *		5713-AFL
 *	LICENSED MATERIALS - PROPERTY OF IBM
 *	(c) Copyright IBM Corporation 1989, 1990
 *	(c) Copyright Locus Computing Corporation 1989, 1990
 *	All Rights Reserved
 */

#ifndef _POSIX_SOURCE
#ifndef H_SCCSID
#include <sccs.h>
#endif /* ~H_SCCSID */
H_SCCSID(@(#)ctab.h	1.1	AIX)	/* Modified 6/26/91 23:27:30 */
#endif

#ifndef _H_CTAB
#define _H_CTAB
#ifndef _h_NLCHAR
typedef unsigned char UCHAR;	/* redefined to avoid including NLchar.h */
#ifdef _MBCS
typedef unsigned long wchar_t;	/* redefined to avoid including mbcs.h */
struct NLctab {
	long	ct_maxctp;		/* Number of chars for ctype */
	long	ct_maxcol;		/* Number of chars for collation */
	long	ct_eqvmax;		/* number of eqv bit maps supplied,
					 * it is ct_maxchr/8 rounded */
	long	ct_extcol;		/* # of extended collation entries  */
	short	*ct_ctype;		/* ctype bitmap 	*/
	wchar_t	*ct_caseconv;		/* alphabetic case conversion */
	short	*ct_collate;		/* collating sequence order */
	short	*ct_coluniq;		/* unique collating values */
	UCHAR	*ct_eqvmap;		/* equivalence class bitmap */
};

#ifndef lint
/*  Defs for accessing collating data.
 */
extern 	struct NLctab _MB_ctab[1] ;

int _wcindx();
#define	__wcindx(c)	 ((!((__c_temp=c)&~0177))? __c_temp : _wcindx(__c_temp))
#endif

#else 	/* not _MBCS */
struct NLctab {
	UCHAR	ct_mag0, ct_mag1; 	/* magic number for ctab output */
	short	ct_version;		/* producer version number */
	UCHAR	ct_ctype[NLCTABMAX];	/* equivalent of old _ctype */
	NLchar	ct_caseconv[NLCTABMAX];	/* alphabetic case conversion */
	short	ct_collate[NLCTABMAX];	/* collating sequence order */
	short	ct_coluniq[NLCTABMAX];	/* unique collating values */
	UCHAR	ct_eqvmap[NLCTBITMX];	/* equivalence class bitmap */
};

extern struct NLctab *_NLctab;

#endif	/* _MBCS */
#endif	/* _h_NLCHAR */
#endif	/* _h_CTAB */
#ifdef __cplusplus
}
#endif
