#ifdef __cplusplus
/* (MRL) I have no idea r.e. the correct prototypes for the functions declared
 * in this header file 
 */
extern "C" {
#endif
#ifndef H_SCCSID
#include <sccs.h>
#endif /* ~H_SCCSID */
H_SCCSID(@(#)fsg.h	1.8	AIX)	/* Modified 9/17/89 00:27:51 */
/*      @(#)fsg.h	5.3 u370  source        */
/* 
 * (C) Copyright IBM Corp. 1989 
 * All Rights Reserved 
 * Licensed Materials - Property of IBM 
 */

struct fsg {
	char	*fs_grp;
	int	fs_id;
	int	fs_shares;
	char	*fs_passwd;
	char	**fs_mem;
};

extern struct fsg *getfsgent();
extern struct fsg *getfsgnam();
extern struct fsg *getfsgid();
extern int putfsgent();
extern int setfsgfil();
extern int isfsg();
extern void setfsgent();
extern void endfsgent();

/*
 * Global fair share scheduler definitions
 */

#define	FSG	"/etc/fsg"	/* fair share group configuration file */
#define	FSGLOCK	"/etc/fsg.lock"
#define FSGTMP1	"/etc/fsg.tmp1"
#define	FSGTMP2	"/etc/fsg.tmp2"
#define FSSCTNAM	".control"	/* name of system controller group */
#define	FSSDNAM		".default"	/* name of system default fair share group */
#define	FSSGRPS	100		/* max elements in fs_mem */
#define FSSSYS  56              /* syscall 56 = fair share scheduler */

#ifndef MAXADMID
#define MAXADMID        -1
#endif

#define ADMINID(x)      (x <= MAXADMID)


/*
 * Fair share scheduler system call macros
 */

#define	fstart(g, f)		fss(FS_START, g, f)
#define	fsrestart()		fss(FS_RESTART, 0, 0)
#define	fstop()			fss(FS_STOP, 0, 0)
#define	fsadd(id, sh)		fss(FS_ADD, id, sh)
#define	fsdelete(fi, ti)	fss(FS_DELETE, fi, ti)
#define	fschuid(fid, uid)	fss(FS_CHUID, fid, uid)
#define	fschpid(fid, pid)	fss(FS_CHPID, fid, pid)
#define	fschpgrp(fid, pgrp)	fss(FS_CHPGRP, fid, pgrp)
#define	fstate()		fss(FS_STATE, 0, 0)
#define	fsid(pid)		fss(FS_ID, pid, 0)
#define	fsread(f)		fss(FS_READ, 0, f)
#define	fssread(s, f)		fss(FS_READ, s, f)
#define	fschpri(c, f)		fss(FS_CPRI, c, f)
#ifdef __cplusplus
}
#endif
