#ifdef __cplusplus
extern "C" {
#endif
#ifndef _POSIX_SOURCE
#ifndef H_SCCSID
#include <sccs.h>
#endif /* ! H_SCCSID */
H_SCCSID(@(#)grp.h	1.19       LCC)    /* Modified: 20:26:19 7/16/90 */
#endif /* NOT _POSIX_SOURCE */
/* @(#)grp.h	7.1 - 87/06/16 - 00:10:56 */
/* 
 * (C) Copyright IBM Corp. 1989 
 * All Rights Reserved 
 * Licensed Materials - Property of IBM 
 */
#ifndef _H_GRP
#define _H_GRP

#include <sys/types.h>

void setgrent(void), endgrent(void);

struct	group {	/* see getgrent(3) */
	char	*gr_name;
	char	*gr_passwd;
	gid_t	gr_gid;
	char	**gr_mem;
};

extern struct group *getgrgid(gid_t), *getgrnam(const char*);

#ifndef _POSIX_SOURCE
extern struct group *getgrent(void);

#ifdef RTPC
#define NGROUPS (64*1024)       /** as many as there are **/
#else
#define NGROUPS 32
#endif

#endif	/* ! _POSIX_SOURCE */

#endif	/* ! _H_GRP */
}
