#ifdef __cplusplus
extern "C" {
#endif
#ifndef H_SCCSID
#include <sccs.h>
#endif /* ~H_SCCSID */
H_SCCSID(@(#)ieee.h	1.8	AIX)	/* Modified 9/16/89 22:42:39 */
/* H_SCCSID(@(#)ieee.h	1.2	LCC)	/* Modified: 17:49:15 3/22/88 */
/* 
* (C) Copyright IBM Corp. 1989, 1989
 * All Rights Reserved 
 * Licensed Materials - Property of IBM 
 */

/*
 * 5799-CGZ (C) COPYRIGHT IBM CORPORATION 1986,1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */

/***************************************************************************/
/*   types for recommended functions and support routines		   */
/***************************************************************************/

typedef enum { 				/* allows user setting and	   */
	TONEAREST, 			/* clearing of rounding mode	   */
	UPWARD, 
	DOWNWARD, 
	TOWARDZERO 
} ROUNDDIR;

typedef enum {				/* every ieee floating point	   */
	SNAN,				/* value is in one and only one	   */
	QNAN,				/* of these classes		   */
	INFINITE,
	ZERONUM,
	NORMALNUM,
	DENORMALNUM 
} NUMCLASS;

#define FPINVALID	1		/* allows user to set and clear    */
#define FPUNDERFLOW	2		/* floating point exception flags  */
#define FPOVERFLOW	4		/* and traps			   */
#define FPDIVBYZERO	8
#define FPINEXACT	16
#define FPALLEXCEPTIONS 0x1f

typedef short FPEXCEPTION;		/* a sum of particular exceptions  */

/***************************************************************************/
/*   IEEE recommended functions and recommended support routines.	   */
/***************************************************************************/

double copysign(double,double), rint(), scalb(double,int), logb(double), 
	drem(), nextdouble(), infinity();
float  nextfloat();
NUMCLASS classfloat(), classdouble();
FPEXCEPTION swapfpflag(), fptestflag();
void fpsetflag(), fpclrflag();
FPEXCEPTION swapfptrap(), fptesttrap();
void fpsettrap(), fpclrtrap();
ROUNDDIR swapround(), fptestround();
void fpsetround();

/***************************************************************************/
/*   Mode specifiers for conversion (ecvt, fcvt) rounding.		   */
/***************************************************************************/

#define	CVT_ROUND	0		/* rounding "to-roundest"	   */
#define	CVT_IEEE	1		/* uses ieee rounding		   */
#ifdef __cplusplus
}
#endif
