#ifdef __cplusplus
extern "C" {
#endif
#ifndef H_SCCSID
#include <sccs.h>
#endif /* ! H_SCCSID */
H_SCCSID(@(#)nlist.h	1.18	AIX)	/* Modified 9/17/89 01:03:44 */
/* @(#)nlist.h	7.4 - 88/01/14 - 09:33:38 */
/* 
 * (C) Copyright IBM Corp. 1989 
 * All Rights Reserved 
 * Licensed Materials - Property of IBM 
 */

#ifndef _h_NLIST
#define _h_NLIST 1

#if	defined(vax) || defined(RTPC) || defined(u370) || defined(i386)
/*
 * In Sys V systems, this file is normally included via a.out.h.
 */


#if	defined(_BSD) || defined(CC4)
struct nlist {
	char	*n_name;	/* name of symbol */
	unsigned char	n_type;	/* i.e. N_TEXT etc; (see below) */
	char	n_other;	/* unused */
	short	n_desc;		/* see <stab.h> */
	unsigned long n_value;	/* value of symbol */
};
#define n_hash n_desc	/* used internally by ld */

#define  N_UNDF	0x0	/* undefined */
#define  N_ABS	0x2	/* absolute */
#define  N_TEXT 0x4	/* text */
#define  N_DATA 0x6	/* data */
#define  N_BSS	0x8 	/* bss */
#define  N_COMM 0x12	/* common (internal to ld) */
#define  N_FN	0x1f	/* file name */

#define  N_EXT	0x1	/* external bit, or'ed in */
#define  N_TYPE	0x1e	/* mask for all the type bits */

/*
 * Sdb entries have some of the N_STAB bits set.
 * These are given is <stab.h>.
 */
#define  N_STAB 0xe0	/* if any of these bits set; an Sdb entry */

/*
 * Format for namelist entries
 */
#define  N_FORMAT "%08x"


#else	/* ~(_BSD || CC4) */

/* nlist entry structure */

struct nlist
{
	char		*n_name;	/* symbol name */
	long		n_value;	/* value of symbol */
	short		n_scnum;	/* section number */
	unsigned short	n_type;		/* type and derived type */
	char		n_sclass;	/* storage class */
	char		n_numaux;	/* number of aux. entries */
};
#endif	/* ~(_BSD || CC4) */

#else	/* ~(vax || RTPC || u370 || i386) */

struct nlist {
	char		n_name[8];	/* symbol name */
	char		n_type;
	char		n_other;
	short		n_desc;
	unsigned	n_value;	/* value of symbol */
};

#endif	/* ~(vax || RTPC || u370 || i386) */

#endif /* _h_NLIST */
#ifdef __cplusplus
int nlist(const char*, struct nlist*);
}
#endif
