extern "C" {
#ifndef _POSIX_SOURCE
#ifndef H_SCCSID
#include <sccs.h>
#endif /* ! H_SCCSID */
H_SCCSID(@(#)pwd.h	1.28       LCC)    /* Modified: 00:21:42 1/12/90 */
#endif /* NOT _POSIX_SOURCE */

/* @(#)pwd.h	7.1 - 87/06/16 - 00:12:20 */
/* 
* Copyright (C)  1989, Locus Computing Corporation
 * All Rights Reserved
 */ 
/* 
 * (C) Copyright IBM Corp. 1989 
 * All Rights Reserved 
 * Licensed Materials - Property of IBM 
 */

#ifndef _H_PWD
#define _H_PWD

#include <sys/types.h>
/*
 *	This structure defines the fields found in each line of /etc/passwd.
 */

struct passwd {
	char	*pw_name;
	char	*pw_passwd;
	uid_t	pw_uid;
	gid_t	pw_gid;
	char	*pw_age;
	int	pw_quota;
	char	*pw_comment;
	char    *pw_etc;
	char	*pw_dir;
	char	*pw_shell;
};

extern struct passwd	*getpwnam(const char*);
extern struct passwd	*getpwuid(uid_t);


#ifndef _POSIX_SOURCE

#define pw_gecos pw_etc

struct comment {
	char	*c_dept;
	char	*c_name;
	char	*c_acct;
	char	*c_bin;
};

extern int		getpw();
extern void		setpwent();
extern void		endpwent();
extern struct passwd	*getpwent();

#define PWDFILE		"/etc/passwd"

#define POSITIVE 1
#define NEGATIVE -1

#endif /* ! _POSIX_SOURCE */
#endif   /* _H_PWD */
#ifdef __cplusplus
}
#endif
