#ifdef __cplusplus
extern "C" {
/* (MRL) I have no idea what the prototypes should be */
#endif
#ifndef H_SCCSID
#include <sccs.h>
#endif /* ~H_SCCSID */
H_SCCSID(@(#)sf.h	1.8.1.1	AIX)	/* Modified 5/8/91 17:22:38 */
/* H_SCCSID(@(#)sf.h	1.2	LCC)	/* Modified: 17:01:34 5/12/88 */
/* 
* Copyright (C)  1989, Locus Computing Corporation
 * All Rights Reserved
 */ 
/* 
 * (C) Copyright IBM Corp. 1989 
 * All Rights Reserved 
 * Licensed Materials - Property of IBM 
 */

/*
   struct sfent: Structure returned by getsite(3) routines.

   Provides information from entries in the /etc/site file.
   Each /etc/site entry (line) looks like this:

   1:Hocus:HOCUS:magic:Abracadabra Model Q:Hocus Q:100
                                                   |---	CPU speed
                                           |-----------	Full site name
                       |-------------------------------	Long CPU type name
                 |-------------------------------------	CPU type name
           |-------------------------------------------	Local File System name
     |-------------------------------------------------	Site name
   |---------------------------------------------------	Site number
*/

struct sf
{
	short	sf_id;			/* Site ID			*/
	char	*sf_sname;		/* One word name of cluster site*/
	char	*sf_local;		/* Local file system name	*/
	char	*sf_ctype;		/* CPU type name		*/
					/* (e.g. i386, i370, xa370	*/
	short	sf_ccode;		/* Cpu type code		*/
	char	*sf_cname;		/* Information pertinent to	*/
					/* cluster site's hardware or	*/
					/* software configuration.	*/
					/* (e.g. CPU model, disk or	*/
					/* memory or coprocessor confi- */
					/* guration or major software	*/
					/* information, such as DOS	*/
					/* capabilities. 		*/
					/* This field is for human use 	*/
					/* only and is not used by any	*/
					/* programs.			*/ 
	char	*sf_fname;		/* Full descriptive name of	*/
					/* cluster site which may 	*/
					/* contain long name, purpose,	*/
					/* or other non-configuration	*/
					/* information.			*/
					/* This field is for human use 	*/
					/* only and is not used by any	*/
					/* programs.			*/ 
	short	sf_speed;		/* CPU speed			*/
};

#define sf_abbrev sf_local
#define	sf_xcode  sf_ccode		/* ...for compatibility...	*/

#define	SITEFNAME	"/etc/site"	/* Name of site file		*/
#define	site_eq(p,q)	(strcmp(p,q)==0)

struct sf	*sfent();		/* Read next site file entry	*/
struct sf	*sfname();		/* Find site entry by name	*/
struct sf	*sfnum();		/* Find site entry by number	*/
struct sf	*sfctype();		/* Find next entry by cpu type	*/
struct sf	*sfxcode();		/* Find next by execution code	*/

/*
 *	Sitefile equivalent routines
 */

/*
 *	The first three routines take a site number as an argument
 */

struct sf	*sfentry();		/* equivalent to stentry()	*/
char		*sfsname();		/* returns name of site		*/
char		*sflocal();		/* returns local file system name */
/*
 *	The last two take a sitename as an argument
 */
char		*sfntolocal();		/* returns local file system name */
int		sfntonum();		/* returns site number		*/
#ifdef __cplusplus
}
#endif
