#ifdef __cplusplus
extern "C" {
#endif
/*
 *		IX/370
 *		5667-126
 *	LICENSED MATERIALS - PROPERTY OF IBM
*	(c) Copyright 1985, 1986, 1989 IBM Corp.
 *	(c) Copyright 1983, 1984, 1985, 1986 Locus Computing Corporation
 *	All Rights Reserved
 */

#ifndef H_SCCSID
#include <sccs.h>
#endif /* ~H_SCCSID */
H_SCCSID(@(#)sgtty.h	16.3	LCC)	/* Modified: 19:04:43 9/16/89 */

/*
Copyright (c) 1984, 1989  Locus Computing Corporation
		All Rights Reserved
*/

/*      @(#)sgtty.h	5.3 u370  source        */
/*
 * Structure for stty and gtty system calls.
 */

#ifndef	_h_SGTTY
#define	_h_SGTTY

#ifndef _h_IOCTL
#ifdef  KERNEL
#include <ioctl.h>
#else  /* ~KERNEL */
#include <sys/ioctl.h>
#endif /* ~KERNEL */
#endif /* _h_IOCTL */

/*
 * Structure for stty and gtty system calls.
 */
typedef struct sgttyb {
	char	sg_ispeed;		/* input speed */
	char	sg_ospeed;		/* output speed */
	char	sg_erase;		/* erase character */
	char	sg_kill;		/* kill character */
#if	defined(vax) 
	short	sg_flags;		/* mode flags */
#else	/* ~(defined(vax))   */
	int	sg_flags;		/* mode flags */
#endif	/* ~(defined(vax)) */
} sgtty_t;

/*
 * Modes
 */
#define	TANDEM	0000001
#define	CBREAK	0000002
#define	LCASE	0000004
#define	ECHO	0000010
#define	CRMOD	0000020
#define	RAW	0000040
#define	ODDP	0000100
#define	EVENP	0040000
#define ANYP	0040100
#define	NLDELAY	0000600
#define TBDELAY 0014000
#define XTABS	TBDELAY
#define	CRDELAY	0003000
#define VTDELAY	0100000
#define BSDELAY 0020000
#define ALLDELAY (BSDELAY|VTDELAY|CRDELAY|TBDELAY|NLDELAY)

#define	CR0	0
#define	CR1	0001000
#define	CR2	0002000
#define	CR3	0003000
#define	NL0	0
#define	NL1	0000400
#define	NL2	0000200
#define	NL3	0000600
#define	TAB0	0
#define	TAB1	0004000
#define	TAB2	0010000
#define	NOAL	0010000	/* NEEDSWORK */

#define	FF0	0
#define	FF1	0100000
#define	BS0	0
#define	BS1	0020000

/*
 * Speeds
 */

#define	B0	0
#define	B50	0000001
#define	B75	0000002
#define	B110	0000003
#define	B134	0000004
#define	B150	0000005
#define	B200	0000006
#define	B300	0000007
#define	B600	0000010
#define	B1200	0000011
#define	B1800	0000012
#define	B2400	0000013
#define	B4800	0000014
#define	B9600	0000015
#define	EXTA	0000016
#define	EXTB	0000017

#endif /* ! _h_SGTTY */
#ifdef __cplusplus
}
#endif
