#ifdef __cplusplus
extern "C" {
#endif
#ifndef H_SCCSID
#include <sccs.h>
#endif /* ~H_SCCSID */
H_SCCSID(@(#)simperr.h	1.12	AIX)	/* Modified 7/2/90 22:57:01 */
/* H_SCCSID(@(#)simperr.h	1.3	LCC)	/* Modified: 9/15/86 09:51:29 */
/* 
 * (C) Copyright IBM Corp. 1989 
 * All Rights Reserved 
 * Licensed Materials - Property of IBM 
 */
#define NO 0
#define YES 1

extern int errno;
extern int sys_nerr;
extern char *sys_errlist[];

#include <stdio.h>

simperr ( int exp, int rc, int err, long time, char* comment )
{
 char *ident="simperr";
 int count;
 count=(int)time;

 for ( count=0;comment[count];count++)
  if (comment[count] == ':') comment[count] = '_' ;

if (exp == 0) 
{ 
  if (rc == 0)
  { /* printf ("%s:%s:succ:exp:0",ident,comment) */;
       return(NO);}
  else
  { printf (_M"%s:%s:fail:uex:%d:%d",ident,comment,0,err); 
    return(YES);};
  
 }
 else
 {
  if ((exp < 0) && (exp != -99))
  {
   if (rc == -1)
    if (err == -(exp))
     { /* printf (_M"%s:%s:fail:exp:%d:%d",ident,comment,rr,-(exp)) */;
          return(NO);}
    else
     { printf ("%s:%s:fail:exp:%d:%d",ident,comment,-(exp),err);
       return(YES);}
   else
   { printf ("%s:%s:succ:uex:%d:0",ident,comment,-exp);
     return(YES);};
   
  }
  else
  {
   if (exp == -99)
   {
    if (rc == 0)
    { printf ("0\n");}
    else
    {
     if (rc == -1)
     { printf ("%d\n",-err);}
     else
     { printf ("1\n");}
    };
    return(NO);
   }
   else /* default  exp >0  */
   {
    if (rc>=0)
    { /* printf ("%s:%s:succ:exp:0",ident,comment) */;
         return(NO);}
    else
    { printf (_M"%s:%s:fail:uex:%d",ident,comment,err);
      return(YES);};
    
   }
  }
 }
}



reltest ( int operand1, int op, char operand2, long time, char* comment )
{
 char *ident="reltest";
 int count;
 count=(int)time;

 for ( count=0;comment[count];count++)
  if (comment[count] == ':') comment[count] = '_' ;

 count = (int)op;
 
 switch (count) 
 { case '=': /*equal*/
             count = ( operand1 == operand2 );
             break;
   case '!': /*not equal*/
             count = ( operand1 != operand2 );
             break;
   case '<': /*greater*/
             count = ( operand1 < operand2 );
             break;
   case '>': /*less*/
             count = ( operand1 > operand2 );
             break;
   case '(': /*greater or equal*/
             count = ( operand1 <= operand2 );
             break;
   case ')': /*less or equal*/
             count = ( operand1 >= operand2 );
             break;
   default : /*not a valid operator*/
             count = ( 1 == 2 );
             break;
 };
 if (count) 
 { return(NO);}
 else
 { 
   printf (_M"%s:%s:result:uex:%d%c%d",ident,comment,operand1,op,operand2);
   return(YES);
 }
}


warning ( char *comment, char *text )
{
 char *ident=_M"warning";
 int count;

 for ( count=0;comment[count];count++)
  if (comment[count] == ':') comment[count] = '_' ;

   printf ("%s:%s:%s",ident,text,comment);
   return(YES);
}


message ( char* comment, char* text )
{
 char *ident=_M"message";
 int count;

 for ( count=0;comment[count];count++)
  if (comment[count] == ':') comment[count] = '_' ;

   printf ("%s:%s:%s",ident,text,comment);
   return(YES);
}

reltlong ( long operand1, char op, long operand2, long time, char* comment )
{
 char *ident="reltest";
 int count;
 count=(int)time;

 for ( count=0;comment[count];count++)
  if (comment[count] == ':') comment[count] = '_' ;

 count = (int)op;
 
 switch (count) 
 { case '=': /*equal*/
             count = ( operand1 == operand2 );
             break;
   case '!': /*not equal*/
             count = ( operand1 != operand2 );
             break;
   case '<': /*greater*/
             count = ( operand1 < operand2 );
             break;
   case '>': /*less*/
             count = ( operand1 < operand2 );
             break;
   case '(': /*greater or equal*/
             count = ( operand1 <= operand2 );
             break;
   case ')': /*less or equal*/
             count = ( operand1 >= operand2 );
             break;
   default : /*not a valid operator*/
             count = ( 1 == 2 );
             break;
 };
 if (count) 
 { return(NO);}
 else
 { 
   printf (_M"%s:%s:result:uex:%ld%c%ld",ident,comment,operand1,op,operand2);
   return(YES);
 }
}
#ifdef __cplusplus
}
#endif
