#ifdef __cplusplus
extern "C" {
#endif
/*
 *		IX/370
 *		5667-126
 *	LICENSED MATERIALS - PROPERTY OF IBM
 *	(c) Copyright 1985, 1986, 1989 IBM Corp.
 *	(c) Copyright 1983, 1984, 1985, 1986,  1989 Locus Computing Corporation
 *	All Rights Reserved
 */


#ifndef _POSIX_SOURCE
#ifndef H_SCCSID
#include <sccs.h>
#endif /* ~H_SCCSID */
H_SCCSID(@(#)stat.h	16.7       LCC)    /* Modified: 19:52:20 1/11/90 */
#endif /* NOT _POSIX_SOURCE */

#ifndef _H_STAT
#define _H_STAT

#include <sys/types.h>

struct stat
{
	dev_t       st_dev;
	ino_t       st_ino;
	mode_t      st_mode;
	nlink_t     st_nlink;
	u_short_t   st_spare0;
	uid_t       st_uid;
	gid_t       st_gid;
	dev_t       st_rdev;
	off_t       st_size;
	time_t      st_atime;
	u_long_t    st_spare1;
	time_t      st_mtime;
	u_long_t    st_spare2;
	time_t      st_ctime;
	u_long_t    st_spare3;
	u_long_t    st_blksize;
	u_long_t    st_blocks;
	u_long_t    st_gen;
	u_long_t    st_type;
	u_long_t    st_vfs;
	u_long_t    st_flag;
	u_long_t    st_cmtcnt;
	fstore_t    st_fstore;
	u_long_t    st_version;
	siteno_t    st_css;
	siteno_t    st_ss;
	siteno_t    st_rdevsite;
	short       st_spare4;
	long        st_nid;
	uid_t       st_uid_raw;
	gid_t       st_gid_raw;
	u_long_t    st_uid_rev_tag;
	u_long_t    st_gid_rev_tag;
};

#ifndef _POSIX_SOURCE

/*
 * Type definitions
 */
#define	VNON	0
#define VBAD	1
#define VREG	2
#define VDIR	3	
#define VHDIR	4
#define VBLK	5
#define VCHR	6
#define VLNK	7
#define VSOCK	8
#define VFIFO	9
#define	VMPC	10

/*
 * Defines to tell whether or not a file or directory
 * is mounted upon, and whether it is local or remote.
 */
#define	FS_NOFLAG	0x0		/* Clear flag		*/
#define FS_VMP		0x1		/* Virtual mount point	*/
#define FS_REMOTE	0x2		/* Remote file primary copy
					 * not local */
#define FS_MOUNT	FS_VMP
#define FS_SHORT	0x4000

#define STATSIZE \
 (((int)(char *)&(((struct stat *)0)->st_spare4)) + (sizeof(short)))

/*
 * Definitions for rev_tags
 */
#define	IDTAG_CALLER	1
#define	IDTAG_OTHER	2
#define	IDTAG_SOMEONE	3
#define	IDTAG_NO_ONE	4

#define FULLSTATSIZE \
 (((int)(char *)&(((struct stat *)0)->st_gid_rev_tag)) + (sizeof(u_long)))

#define STX_LINK	0x0001
#define STX_MOUNT	0x0002
#define STX_HIDDEN	0x0004
#define STX_TRANS	0x0000
#define STX_TRANS_NONE	0x0008
#define STX_TRANS_OTHER	0x0010

#endif /* ! _POSIX_SOURCE */

#define	_S_IFMT   0x3000f000	/* type of file */
#define	_S_IFDIR  0x4000	/* directory */
#define S_ISDIR(m) (((m) & (_S_IFMT)) == (_S_IFDIR))
#define	_S_IFCHR  0x2000	/* character special */
#define S_ISCHR(m) (((m) & (_S_IFMT)) == (_S_IFCHR))
#define	_S_IFBLK  0x6000	/* block special */
#define S_ISBLK(m) (((m) & (_S_IFMT)) == (_S_IFBLK))
#define	_S_IFREG  0x8000	/* regular */
#define S_ISREG(m) (((m) & (_S_IFMT)) == (_S_IFREG))
#define	_S_IFIFO  0x1000	/* named pipe */
#define S_ISFIFO(m) (((m) & (_S_IFMT)) == (_S_IFIFO))

#ifndef _POSIX_SOURCE
#define	S_IFMT	_S_IFMT
#define	S_IFDIR	_S_IFDIR
#define	S_IFCHR	_S_IFCHR
#define	S_IFBLK	_S_IFBLK
#define	S_IFREG	_S_IFREG
#define	S_IFIFO	_S_IFIFO

#define	S_IFLNK 0xa000  	/* symbolic link */
#define S_ISLNK(m) (((m) & (S_IFMT)) == (S_IFLNK))
#define S_IFSOCK 0xc000		/* named socket */
#define S_ISSOCK(m) (((m) & (S_IFMT)) == (S_IFSOCK))
#define S_IFMPX (S_IFCHR|S_ISVTX)  /* multiplex character special file */
#define S_ISMPX(m) (((m) & (S_IFMT|S_ISVTX)) == (S_IFMPX))
#define S_IHIDDEN 0x8000000	/* hidden directory */
#define S_ISHIDDEN(m) (((m) & (S_IFMT|S_IHIDDEN)) == (S_IFDIR|S_IHIDDEN))

#endif /* ! _POSIX_SOURCE */


#define	S_ISUID	 04000		/* set user id on execution */
#define	S_ISGID	 02000		/* set group id on execution */

#ifndef _POSIX_SOURCE
#define S_ENFMT  S_ISGID        /* record locking enforcement flag */
#define	S_ISVTX	 01000		/* save swapped text even after use */
#define	S_IREAD	 00400		/* read permission, owner */
#define	S_IWRITE 00200		/* write permission, owner */
#define	S_IEXEC	 00100		/* execute/search permission, owner */

/*  /usr/group definitions  */
#define S_PERM	 00777		/* all permission fields */
#endif /* ! _POSIX_SOURCE */

#define S_IRWXU  00700          /* read,write,execute permission: owner */
#define S_IRUSR  00400          /* read permission: owner */
#define S_IWUSR  00200          /* write permission: owner */
#define S_IXUSR  00100          /* execute/search permission: owner */
#define S_IRWXG  00070          /* read,write,execute permission: group */
#define S_IRGRP  00040          /* read permission: group */
#define S_IWGRP  00020          /* write permission: group */
#define S_IXGRP  00010          /* execute/search permission: group */
#define S_IRWXO  00007          /* read,write,execute permission: other */
#define S_IROTH  00004          /* read permission: other */
#define S_IWOTH  00002          /* write permission: other */
#define S_IXOTH  00001          /* execute/search permission: other */

#ifndef _KERNEL
extern mode_t umask(mode_t);                              
extern int mkdir(const char*, mode_t), 
	mkfifo(const char*, mode_t), 
	stat(const char*, struct stat*), 
	fstat(int, struct stat*), 
	chmod(const char*, mode_t);
#endif	/* !_KERNEL */

#endif /* ~_H_STAT */
#ifdef __cplusplus
}
#endif
