#ifdef __cplusplus
extern "C" {
#endif
/* 
 *	LICENSED MATERIALS - PROPERTY OF IBM
 * 	(c) Copyright IBM Corp. 1989
 *	(c) Copyright Locus Computing Corporation 1989
 * 	All Rights Reserved 
 */

#ifndef _POSIX_SOURCE
#ifndef H_SCCSID
#include <sccs.h>
#endif /* ! H_SCCSID */
H_SCCSID(@(#)stdio.h	1.37	AIX)	/* Modified 6/26/91 21:47:21 */
#endif /* NOT _POISX_SOURCE */

#ifndef _H_STDIO
#define _H_STDIO

#ifdef CC4
#define _NFILE	20

#else /* !CC4 */

/* For Dynamic iob's. Make sure _NFILE is
  a multiple of _NIOBRW (IOB Row).
*/
#define _NFILE	200
#define _NIOBRW	20
#define _NRWS	((_NFILE / _NIOBRW )+1)

			/* Number of iob rows should be equal
			   to (_NFILE / _NIOBRW ) + 1.  The extra
			   row ensures insures that the _NFILE+1th
			   fopen fails because of open(). 
			 */
#endif /* !CC4 */

#if defined(M_I286) && !defined(X_286)
#define X_286 1
#endif /* defined(M_I286) && !defined(X_286) */ 

#ifdef  CC4

#ifdef	V7
#define	BUFSIZ	512
#else	/* V7~ */
#define	BUFSIZ	1024
#endif	/* V7 */

#else  /* ~CC4 */

#if	X_286
#define BUFSIZ	512
#else
#if	RTPC
#define BUFSIZ	2048
#else
#define BUFSIZ	4096
#endif
#endif

#endif /* ~CC4 */


#ifdef  CC4
# ifndef FILE
extern	struct	_iobuf {
#ifdef	V7
	char	*_ptr;
	int	_cnt;
#else	/* V7~ */
	int	_cnt;
	char	*_ptr;
#endif	/* V7~ */
	char	*_base;
#ifdef	V7
	char	_flag;
#else	/* V7~ */
	short	_flag;
#endif	/* V7~ */
	char	_file;
} _iob[_NFILE];

#define	FILE	struct _iobuf
# endif	/* FILE- */

#else  /* ~CC4 */

/* buffer size for multi-character output to unbuffered files */
#define _SBFSIZ 8

typedef struct {
	unsigned char	*_ptr;
	int	_cnt;
	unsigned char	*_base;
	unsigned char   *_bufendp;
	short	_flag;
	short	_file;
	int	_unused[3];
} FILE;

#endif /* ~CC4 */

/*
 * _IOLBF means that a file's output will be buffered line by line
 * In addition to being flags, _IONBF, _IOLBF and _IOFBF are possible
 * values for "type" in setvbuf.
 */
#define _IOFBF		0000
#define _IOREAD		0001
#define _IOWRT		0002
#define _IONBF		0004
#define _IOMYBUF	0010
#define _IOEOF		0020
#define _IOERR		0040

#if defined(CC4) 
#define	_IOSTRG		0100
#define _IOLBF		0200
#define	_IORW		0400
#else  /* ~CC4 */
#define _IOLBF		0100
#define _IORW		0200
#define	_IONOFD		0400
#endif /* ~CC4 */

#ifndef NULL
#define NULL		0
#endif
#ifndef EOF
#define EOF		(-1)
#endif

#define stdin		(&_iob[0])
#define stdout		(&_iob[1])
#define stderr		(&_iob[2])

/*	Definition for POSIX	*/
#define	TMP_MAX	4096
#define	FOPEN_MAX 200

// (MRL) typedef	long	size_t;
typedef unsigned long size_t;

#ifdef CC4
#define _bufend(p)	_bufendtab[(p)->_file]
#else /* !CC4 */
#define _bufend(p)	((p)->_bufendp)
#endif /* !CC4 */

#define _bufsiz(p)	(_bufend(p) - (p)->_base)

#ifndef lint
#ifdef  CC4
#define	getc(p)		(--(p)->_cnt>=0? *(p)->_ptr++&0377:_filbuf(p))
#define putc(x,p) (--(p)->_cnt>=0? ((int)(*(p)->_ptr++=(x))):_flsbuf((int)(unsigned char)(x),p))
#else  /* ~CC4 */
#define getc(p)		(--(p)->_cnt < 0 ? _filbuf(p) : (int) *(p)->_ptr++)
#define putc(x, p)	(--(p)->_cnt < 0 ? \
			_flsbuf((unsigned char) (x), (p)) : \
			(int) (*(p)->_ptr++ = (unsigned char) (x)))
#endif /* ~CC4 */

#define getchar()	getc(stdin)
#define putchar(x)	putc((x), stdout)
#define clearerr(p)	((void) ((p)->_flag &= ~(_IOERR | _IOEOF)))
#define feof(p)		((p)->_flag & _IOEOF)
#define ferror(p)	((p)->_flag & _IOERR)
#define fileno(p)	((p)->_file)
#endif /* ~lint */

extern FILE	*fopen(const char *, const char *), 
		*fdopen(int, const char *), 
		*freopen(const char *, const char *, FILE *), 
		*popen(const char *, const char *), 
		*rpopen(...), /* (MRL) Unknown prototype */
		*tmpfile(void);
extern long	ftell(FILE*);
extern void	rewind(FILE*), setbuf(FILE*,char*);
extern char	*ctermid(char *), 
		*cuserid(char *), 
		*fgets(char *, int, FILE *), 
		*gets(char *), 
		*tempnam(const char *, const char *), 
		*tmpnam(char*);

extern int	fclose(FILE*);
extern int 	_flsbuf(unsigned char, FILE*);
extern int 	_filbuf(FILE*);
extern int	fflush(FILE*);
extern int	fgetc(FILE*);
extern int	fprintf(FILE *, const char * ...);
extern int	fputc(int, FILE *);
extern int	fputs(const char *, FILE *);
extern size_t	fread(void *, size_t, size_t, FILE *);
extern int	fscanf(FILE *, const char * ...);
extern int	fseek(FILE *, long, int);
extern size_t	fwrite(const void *, size_t, size_t, FILE *);
extern void	perror(const char *);
extern int	printf(const char * ...);
extern int	puts(const char *);
extern int	remove(const char *);
extern int	rename(const char *,const char *);
extern int	scanf(const char * ...);
extern int	setvbuf(FILE *, char *, int, size_t);
extern int	sprintf(char *, const char * ...);
extern int	sscanf(const char *, const char * ...);
extern int	ungetc(int, FILE *);
#include <stdarg.h>
extern int	vfprintf(FILE*, const char*, va_list);
extern int	vsprintf(char*, const char*, va_list);
extern int	vprintf(const char*, va_list);

#ifndef CC4
extern FILE	_iob[_NIOBRW];

#define L_ctermid	9
#define L_cuserid	9
#define P_tmpdir        "/tmp/"
#define L_tmpnam	(sizeof(P_tmpdir) + 15)
#endif /* !CC4 */


#ifdef M_I286
#define	LFNMAX		15		/* max len for filename */
#define	LPNMAX		128		/* (practical) max len for pathname */
#endif /* M_I286 */

/* Symbolic constants for the "lseek" function: */
#define SEEK_SET 0	/* Set file pointer to "offset" */
#define SEEK_CUR 1	/* Set file pointer to current plus "offset" */
#define SEEK_END 2	/* Set file pointer to EOF plus "offset" */

#ifdef _MBCS

#ifndef _POSIX_SOURCE
#ifndef _h_MBCS
#include <mbcs.h>
#endif
#endif

typedef unsigned long wchar_t;			/* This is against ansi rule */
						/* except we need wchar_t    */
						/* defined for out functions */

#ifndef	lint					/* proto-types do not work   */
						/* with lint                 */

wchar_t	fgetwc(FILE *);
wchar_t	*fgetws(wchar_t *, int, FILE *);
wchar_t	*getws(wchar_t *);
wchar_t fputwc(wchar_t, FILE *);
int	fputws(wchar_t *, FILE *);
wchar_t getwc(FILE *);
wchar_t getwchar(void);
wchar_t putwc(wchar_t, FILE *);
wchar_t putwchar(wchar_t);
int	putws(wchar_t *);
wchar_t ungetwc(wchar_t, FILE *);

#endif  /* lint */

#ifndef _POSIX_SOURCE
#define	WEOF	((wchar_t)-1)

#define getwchar()		getwc(stdin)
#define NCgetc(stream)		getwc(stream)
#define NCgetchar()		getwc(stdin)

#define	getwc(stream)		fgetwc(stream)

#define NCputchar(wc)		putwchar(wc)
#define putwchar(wc)		putwc(wc, stdout)

#define	NCputc(wc, stream)	putwc(wc, stream)
#define	putwc(wc, stream)	fputwc(wc, stream)

#define	NCungetc(wc,stream)	ungetwc(wc,stream)

#endif						/* NOT _POSIX_SOURCE */
#endif						/* _MBCS */

#endif						/* _H_STDIO */
#ifdef __cplusplus
}
#endif
