#ifdef __cplusplus
extern "C" {
#endif
/*
 *		IX/370
 *		5667-126
 *	LICENSED MATERIALS - PROPERTY OF IBM
*	(c) Copyright 1985, 1986, 1989 IBM Corp.
*	(c) Copyright 1983, 1984, 1985, 1986, 1989 Locus Computing Corporation
 *	All Rights Reserved
 */

#ifndef H_SCCSID
#include <sccs.h>
#endif /* ~H_SCCSID */
H_SCCSID(@(#)acct.h	16.5	LCC)	/* Modified: 16:01:18 2/4/92 */
/* SCCSIDPUFF(@(#) acct.h 4.1 LM 12:50:31 4/23/85 C 22:11:45 4/23/85); */
#ifndef	_h_ACCT
#define	_h_ACCT

#ifndef _h_TYPES
#ifdef  KERNEL
#include <types.h>
#else  /* ~KERNEL */
#include <sys/types.h>
#endif /* ~KERNEL */
#endif /* ~_h_TYPES */

/*
 * Accounting structures;
 * these use a comp_t type which is a 3 bits base 8
 * exponent, 13 bit fraction ``floating point'' number.
 */
typedef	u_short comp_t;
struct	acct
{
	char	ac_flag;		/* Accounting flag */
	char	ac_stat;		/* Exit status */
	u_short	ac_uid;			/* Accounting user ID */
	u_short	ac_gid;			/* Accounting group ID */
	dev_t	ac_tty;			/* control typewriter */
	time_t	ac_btime;		/* Beginning time */
	comp_t	ac_utime;		/* acctng user time in clock ticks */
	comp_t	ac_stime;		/* acctng system time in clock ticks */
	comp_t	ac_etime;		/* acctng elapsed time in clock ticks */
	comp_t	ac_mem;			/* memory usage */
	comp_t	ac_io;			/* chars transferred */
	comp_t	ac_rw;			/* blocks read or written */
	char	ac_comm[8];		/* command name */
};	

#ifdef  KERNEL
extern	struct	acct	acctbuf;
extern	struct	inode	*acctp;		/* inode of accounting file */
#endif  /* KERNEL */

#define A_get_fsid(X)	((X>>2)&017)
#define A_put_fsid(X)	( X | ( (u.u_procp->p_fair) ? \
				((u.u_procp->p_fair->fs_id<<2) & 074) : 0 ) )
#define	AFORK	01		/* has executed fork, but no exec */
#define	ASU	02		/* used super-user privileges */
#define	ACCTF	0300		/* record type: 00 = acct */

#define ACORE	0010		/* dumped core */
#define AXSIG	0020		/* killed by a signal */
#define	ACOMPAT	0004		/* used compatibility mode */
#define	AHZ	HZ		/* 1/AHZ is the granularity of the data encoded
				   in various comp_t fields.  This is not
				   necessarily equal to hz.  */

#ifdef  b370

#ifdef	_c_MACHDEP
#define EXTERN
#else
#define	EXTERN	extern
#endif	/* _c_MACHDEP */

/*
 * Calculate the number of sec's and usec's. Allow for the possibility of
 * multi second time accumulations. It should be much less than a second
 * but just in case we'll do the right thing.                          
 *
 */
#define BUMPTIME(t) { \
	register struct timeval *tp = (t); \
	unsigned int    usec; \
 \
	usec = getcputime(); \
	charge_u->u_delta_time += usec; \
	tp->tv_usec += (usec); \
	while ( tp->tv_usec >= 1000000 ) \
	{ \
	        tp->tv_usec -= 1000000; \
	        tp->tv_sec++; \
        } \
}
extern long getcputime();

	/* The overhead process' user structures. */
EXTERN struct user *ovrhd_u;

#ifdef IO_OVERHEAD
EXTERN struct user *ioovrhd_u;
#endif	/* IO_OVERHEAD */

	/* Pointer to the user structure that gets charged for system time. */
EXTERN struct user *charge_u;

#endif  b370
#ifdef __cplusplus
/* (MRL) I am presuming that this function is available */
	int acct(const char *);
#endif

#endif /* ~_h_ACCT */
#ifdef __cplusplus
}
#endif
