#ifdef __cplusplus
extern "C" {
#endif
/*
 *		AIX/370
 *		57-AFL
 *	LICENSED MATERIALS - PROPERTY OF IBM
*	(c) Copyright 1985, 1986, 1989 IBM Corp.
*	(c) Copyright 1983, 1984, 1985, 1986, 1989 Locus Computing Corporation
 *	All Rights Reserved
 */

#include <sccs.h>
H_SCCSID(@(#)clock.h	1.2    IBM AIX)    /* Modified: 20:01:52 7/15/92 */
/*H_SCCSIDgen1(@(#)clock.h	11.12	LCC)	/* Modified: 11:12:02 11/21/88 */

#ifndef _h_CLOCK
#define _h_CLOCK

#define SECMIN		((unsigned) 60)			/* seconds per min. */
#define	SECHR		((unsigned) (60 * 60))		/* seconds per hour */
#define	SECDAY		((unsigned)(24*60*60))		/* seconds per day */
#define	SECYR		((unsigned)(365*SECDAY))	/* per common year */
#define	YRREF		1970
#define	LEAPYEAR(year)	((year)%4==0)	/* good till time becomes negative */

#ifdef	vax
/*
 * VAX clock registers
 */

#define	ICCS_RUN	0x00000001
#define	ICCS_TRANS	0x00000010
#define	ICCS_SS		0x00000020
#define	ICCS_IE		0x00000040
#define	ICCS_INT	0x00000080
#define	ICCS_ERR	0x80000000
	
/*
 * TODRZERO is the what the TODR should contain when the ``year'' begins.
 * The TODR should always contain a number between 0 and SECYR+SECDAY.
 */
#define	TODRZERO	((unsigned)(1<<28))

#ifdef TIME_SYNC
/*
 * Start the clock.
 */
#define	clkstart() {\
	mtpr(NICR, -usec_per_tick);\
	mtpr(ICCS, (int) ICCS_RUN+ICCS_IE+ICCS_TRANS+ICCS_INT+ICCS_ERR);\
}
#else
/*
 * Start a 60 HZ clock.
 */
#define	clkstart() {\
	mtpr(NICR, -16667);	/* 16.667 milli-seconds */\
	mtpr(ICCS, (int) ICCS_RUN+ICCS_IE+ICCS_TRANS+ICCS_INT+ICCS_ERR);\
}
#endif /* TIME_SYNC */
 
#define	clkreld()	mtpr(ICCS, ICCS_RUN+ICCS_IE+ICCS_INT+ICCS_ERR)
#define	clkstop()	mtpr(ICCS, 0)
#define	clkwrap()	(((unsigned)mfpr(TODR) - TODRZERO)/100 > SECYR+SECDAY)

/*
 * Software clock is software interrupt level 8
 */
#define	setsoftclock()	mtpr(SIRR, 0x8)
#endif	/* vax */

#if	 defined(i386)
#define	setsoftclock()	schedrtcintr(clk_swintr)

#ifdef KERNEL
int clk_swintr;		/* handle for scheduling clock software interrupts */
#endif

#endif	 /* defined(i386) */


#if	defined(i386)
#define	clkreld() tclkreld()
#endif	/* i386 */

#ifdef	b370

extern int Softclock;
extern	int	start_clk;

#define	setsoftclock()	Softclock++

/* Use the CPU timer */
#define	TIMER_HZ	(1000000/hz)
#define	TIMER_LONG	0x7fffffff

#define	clkstart()	start_clk = 1, Clkstart(TIMER_HZ)
#define	clkstop()	start_clk = 0, Clkstart(TIMER_LONG)
#define	clkreld()	Clkreld(TIMER_HZ)
#define	clkwrap()	(0)
#define	clkset()

#endif	/* b370 */
#ifdef __cplusplus
/* (MRL) I don't know if this is function is available */
	void delay(long);
#endif

#endif /* ~_h_CLOCK */
#ifdef __cplusplus
}
#endif
