#ifdef __cplusplus 
extern "C" {
#endif
/*
 *		IX/370
 *		5667-126
 *	LICENSED MATERIALS - PROPERTY OF IBM
*	(c) Copyright 1985, 1986, 1989 IBM Corp.
*	(c) Copyright 1983, 1984, 1985, 1986,  1989 Locus Computing Corporation
 *	All Rights Reserved
 */

#ifndef _POSIX_SOURCE
#ifndef H_SCCSID
#include <sccs.h>
#endif /* ~H_SCCSID */
H_SCCSID(@(#)errno.h	16.12       LCC)    /* Modified: 15:12:59 1/16/90 */
#endif /* NOT _POSIX_SOURCE */

#ifndef _H_ERRNO
#define	_H_ERRNO

#ifndef _POSIX_SOURCE
#include <DOPTIONS.h>
#endif /* NOT _POSIX_SOURCE */

/*
 * Error codes
 */

#define	EPERM	1	/* Operation not permitted		*/
#define	ENOENT	2	/* No such file or directory		*/
#define	ESRCH	3	/* No such process			*/
#define	EINTR	4	/* Interrupted system call		*/
#define	EIO	5	/* Input/Output error			*/
#define	ENXIO	6	/* No such device or address		*/
#define	E2BIG	7	/* Arg list too long			*/
#define	ENOEXEC	8	/* Exec format error			*/
#define	EBADF	9	/* Bad file number			*/
#define	ECHILD	10	/* No child processes			*/
#define	EAGAIN	11	/* Resource temprarily unavailable	*/

#ifdef _BSD
#define	EWOULDBLOCK EAGAIN	/* for BSD compatibility	*/
#endif /* _BSD */

#define	ENOMEM	12	/* Not enough space			*/
#define	EACCES	13	/* Permission denied			*/
#define	EFAULT	14	/* Bad address				*/
#define	ENOTBLK	15	/* Block device required		*/
#define	EBUSY	16	/* Resource busy			*/
#define	EEXIST	17	/* File exists				*/
#define	EXDEV	18	/* Improper link			*/
#define	ENODEV	19	/* No such device			*/
#define	ENOTDIR	20	/* Not a directory			*/
#define	EISDIR	21	/* Is a directory			*/
#define	EINVAL	22	/* Invalid argument			*/
#define	ENFILE	23	/* Too many open files in system	*/
#define	EMFILE	24	/* Too many open files			*/
#define	ENOTTY	25	/* Inappropriate I/O control operation	*/
#define	ETXTBSY	26	/* Text file busy			*/
#define	EFBIG	27	/* File too large			*/
#define	ENOSPC	28	/* No space left on device		*/
#define	ESPIPE	29	/* Invalid seek				*/
#define	EROFS	30	/* Read only file system		*/
#define	EMLINK	31	/* Too many links			*/
#define	EPIPE	32	/* Broken pipe				*/

/* math software */
#define	EDOM	33	/* Domain error				*/
#define	ERANGE	34	/* Result too large			*/
#define	ENOMSG	35	/* No message of desired type		*/
#define	EIDRM	36	/* Identifier removed			*/
#define	ECHRNG	37	/* Channel number out of range		*/
#define	EL2NSYNC 38	/* Level 2 not synchronized		*/
#define	EL3HLT	39	/* Level 3 halted			*/
#define	EL3RST	40	/* Level 3 reset			*/
#define	ELNRNG	41	/* Link number out of range		*/
#define	EUNATCH 42	/* Protocol driver not attached		*/
#define	ENOCSI	43	/* No CSI structure available		*/
#define	EL2HLT	44	/* Level 2 halted			*/
#define EDEADLK 45	/* Record locking deadlock		*/

#define ENOTREADY	46	/* Device not ready		*/
#define EWRPROTECT	47	/* Write-protected media 	*/
#define EFORMAT		48	/* Unformatted or incompatible media */
#define ENOLCK		49	/* No locks available		*/
#define ENOCONNECT      50      /* Cannot establish connection  */
#define EBADCONNECT     51      /* Connection down     		*/
#define ESTALE          52      /* Missing file or filesystem   */
#define EDIST           53      /* Requests blocked by Administrator */

/* non-blocking and interrupt i/o */
#ifndef _BSD
#define EWOULDBLOCK	54	/* Operation would block	*/
#endif /* _BSD */
#define EINPROGRESS     55      /* Operation now in progress	*/
#define EALREADY        56      /* Operation already in progress */

/* ipc/network software */

	/* argument errors */
#define ENOTSOCK        57      /* Socket operation on non-socket	*/
#define EDESTADDRREQ    58      /* Destination address required		*/
#define EMSGSIZE        59      /* Message too long			*/
#define EPROTOTYPE      60      /* Protocol wrong type for socket	*/
#define ENOPROTOOPT     61      /* Protocol not available		*/
#define EPROTONOSUPPORT 62      /* Protocol not supported		*/
#define ESOCKTNOSUPPORT 63      /* Socket type not supported		*/
#define EOPNOTSUPP      64      /* Operation not supported on socket	*/
#define EPFNOSUPPORT    65      /* Protocol family not supported 	*/
#define EAFNOSUPPORT    66      /* Address family not supported by protocol */
#define EADDRINUSE      67      /* Address already in use		*/
#define EADDRNOTAVAIL   68      /* Cannot assign requested address 	*/

	/* operational errors */
#define ENETDOWN        69      /* Network is down			*/
#define ENETUNREACH     70      /* Network is unreachable		*/
#define ENETRESET       71      /* Network dropped connection on reset	*/
#define ECONNABORTED    72      /* Software caused connection abort	*/
#define ECONNRESET      73      /* Connection reset by peer		*/
#define ENOBUFS         74      /* No buffer space available		*/
#define EISCONN         75      /* Socket is already connected		*/
#define ENOTCONN        76      /* Socket is not connected		*/
#define ESHUTDOWN       77      /* Cannot send after socket shutdown	*/
#define ETIMEDOUT       78      /* Connection timed out			*/
#define ECONNREFUSED    79      /* Connection refused			*/

#define EHOSTDOWN       80      /* Host is down				*/
#define EHOSTUNREACH    81      /* No route to host			*/

#define ELOOP		85	/* Symbolic link loop			*/

#define ENAMETOOLONG	86	/* File name too long			*/
#ifdef _BSD
#define ENOTEMPTY	EEXIST
#else /* NOT _BSD */
#define	ENOTEMPTY	87	/* Directory not empty */
#endif /* NOT _BSD */

#define	EDQUOT		88	/* Disc quota exceeded			*/

/* errors for System V shared libraries. */
#define	ELIBACC		89	/* Shared library cannot be accessed	*/
#define	ELIBBAD		90	/* Shared library format is bad		*/
#define	ELIBSCN		91	/* .lib section in executable is corrupted */
#define	ELIBMAX		92	/* Too many shared libraries		*/


/* error codes for TCF code */
#define	ESITEDN1	94	/* Required site is not available	*/
#define	ESITEDN2	95	/* Operation terminated due to site failure */
#define	ENOSTORE	96	/* File or working directory is unavailable */
#define	ENLDEV		97	/* Not a local device.			*/
#define	EBADST		98	/* Bad site specification		*/
#define	ELDWRG		99	/* Load module not for this machine	*/
#define	ELOCALONLY	100	/* Operation restricted to local site	*/

#define	ELOCK		101	/* Lock conflict			*/
#define	ETABLE		102	/* Miscellaneous system table full	*/
#define	EXGFS		103	/* Improper mount operation requested	*/

#ifndef _POSIX_SOURCE
#define	EJOURNAL	105	/* Undefined journal operation		*/
#endif	/* NOT _POSIX_SOURCE */

#define	EPBUSY		106	/* Pack is busy				*/

#ifndef _POSIX_SOURCE
#define	ENSPEC		107	/*					*/
#define	EDLOCK		108	/*					*/
#endif	/* NOT _POSIX_SOURCE */

#define ENOSYS		109	/* Function not implemented		*/

#ifdef _KERNEL
/*
 *  The following codes are used only internally by the kernel as return
 *  codes, to be consistent with the fact that the return code in netmsg's
 *  is always the value of u.u_error.
 */

#define RQUOTA		113	/* soft quota limit reached */
#define	RIBUSY		114	/* inode busy (used for propagation in) */
#define	RNOCFLT		115	/* trying to open a specific version when
				 * there is no conflict */
#define	RILOCK		116	/* inode is ILOCKed, and although we have
				 * waited, it has not unlocked.  */
#define	RUNSTABLE	117	/* a configuration change has occurred, and
				 * the new CSS for this gfs is not yet ready
				 * to process opens */
#define	RNOTCSS		118	/* CSS request made at non-CSS site
				 * (for topchg) */
#define	RRMTFRK  	119	/* remote fork problem */
#define	RSLEEP	 	120	/* used for remote sleep wakeup */
#define	RRETRY		121	/* return after remote sleep indicating to 
				 * redo operation */
#define	RWCMIT		122	/* Not doing ss_commit because IWCOMMIT set */
#define	RNOTHERE	123	/* Pid you are looking for is not here and its
				 * whereabouts are unknown (cf. RTRYSITE) */
#define	RTRYSITE	124	/* Your pid's not here; try over yonder */
#define	RDELAYED	125	/* Delayed response will follow later	*/
#define	RPIPEMP		126	/* on fifo reads -- tells reader to sleep. */
#define RNFS		127	/* operation failed, NFS requires special att.*/
#define	RBNDELAY	128	/* operation w/NDELAY would have blocked */

#define RNFSFLOW	129     /* tcf retry nfs operation later */
#define MAXERR		129	/* Largest currently used error number */

	/* old names for temporary compatability */
#define	EUNSTABLE	RUNSTABLE
#define	ENOCFLT		RNOCFLT
#define	ENOTCSS		RNOTCSS
#define	EIBUSY		RIBUSY
#define	EILOCK		RILOCK

/* classify error numbers */
#define	ERR_NORM	1	/* can occur without any "real" error	*/
#define	ERR_PDEP	2	/* permanent, site dependent error	*/
#define	ERR_TDEP	3	/* temporary, site dependent error	*/
#define	ERR_TIND	4	/* temporary, site independent error	*/
#define	ERR_PIND	5	/* permanent, site independent error	*/
#define	ERR_DEFAULT	6	/* unexpected error, complain		*/
#define	ERR_RETRY	7	/* transient error, retry operation	*/

#endif	/* _KERNEL */

#endif	/* NOT _H_ERRNO */
#ifdef __cplusplus 
        void perror(const char*);
        extern int sys_nerr;
        extern char *sys_errlist[];
}
#endif
