#ifdef __cplusplus
extern "C" {
#endif
/*
 *		IX/370
 *		5667-126
 *	LICENSED MATERIALS - PROPERTY OF IBM
*	(c) Copyright 1985, 1986, 1989 IBM Corp.
*	(c) Copyright 1983, 1984, 1985, 1986,  1989 Locus Computing Corporation
 *	All Rights Reserved
 */

/*	@(#)filehdr.h	2.3 1/19/83 */
#ifndef H_SCCSID
#include <sccs.h>
#endif /* ~H_SCCSID */
H_SCCSID(@(#)filehdr.h	16.5	LCC)	/* Modified: 15:55:37 7/13/90 */
/* SCCSIDPUFF(@(#) filehdr.h 4.3 LM 00:08:09 6/21/85 C 00:08:14 6/21/85); */

#ifndef	_h_FILEHDR
#define	_h_FILEHDR

struct filehdr {
	unsigned short	f_magic;	/* magic number */
	unsigned short	f_nscns;	/* number of sections */
	long		f_timdat;	/* time & date stamp */
	long		f_symptr;	/* file pointer to symtab */
	long		f_nsyms;	/* number of symtab entries */
	unsigned short	f_opthdr;	/* sizeof(optional hdr) */
	unsigned short	f_flags;	/* flags */
	};


/*
 *   Bits for f_flags:
 *
 *	F_RELFLG	relocation info stripped from file
 *	F_EXEC		file is executable  (i.e. no unresolved
 *				externel references)
 *	F_LNNO		line nunbers stripped from file
 *	F_LSYMS		local symbols stripped from file
 *	F_MINMAL	this is a minimal object file (".m") output of fextract
 *	F_UPDATE	this is a fully bound update file, output of ogen
 *	F_SWABD		this file has had its bytes swabbed (in names)
 *	F_AR16WR	this file created on AR16WR machine(e.g. 11/70)
 *	F_AR32WR	this file created on AR32WR machine(e.g. vax)
 *	F_AR32W		this file created on AR32W machine (e.g. 3b,maxi)
 *	F_PATCH		file contains "patch" list in optional header
 *	F_NODF		(minimal file only) no decision functions for
 *				replaced functions
 *	F_DEFERC	all files opened for write will be defer committed
 */

#define  F_RELFLG	0000001
#define  F_EXEC		0000002
#define  F_LNNO		0000004
#define  F_LSYMS	0000010
#define  F_MINMAL	0000020
#define  F_UPDATE	0000040
#define  F_SWABD	0000100
#define  F_AR16WR	0000200
#define  F_AR32WR	0000400
#define  F_AR32W	0001000
#define  F_PATCH	0002000
#define  F_NODF		0002000
#define  F_DEFERC	0004000
#define  F_COMMIT	0004000		/* NOT SUPPORTED */


/*
 *   Magic Numbers
 */

	/* Intel */
#define  IAPX16		0504
#define  IAPX16TV	0505
#define  IAPX20		0506
#define  IAPX20TV	0507

#define  IAPX16F	0x4401
#define  IAPX16TVF	0x4501
#define  IAPX20F	0x4601
#define  IAPX20TVF	0x4701

	/* Basic-16 */

#define  B16MAGIC	0502
#define  BTVMAGIC	0503
#define  B16MAGICF	0x4201
#define  BTVMAGICF	0x4301

	/* x86 */

#define  X86MAGIC	0510
#define  XTVMAGIC	0511
#define  X86MAGICF	0x4801
#define  XTVMAGICF	0x4901

	/* Intel 286 */
#define I286SMAGIC	0512
#define I286LMAGIC	0522	/* used by mc68000 (UNIX PC) and iAPX 286 */

#define I286SMAGICF	0x4a01
#define I286LMAGICF	0x5201

	/* Intel 386 */

#define  I386MAGIC	0565	/* Danbury AIX C compiler */
#define  I386SVMAGIC	0514	/* System V C Compiler */

#define  I386MAGICF	0x7501
#define  I386SVMAGICF	0x4c01

	/* 68000 */

#define  M68MAGIC	0210
#define  M68TVMAGIC	0211
#define  MC68MAGIC	0520
#define  MC68TVMAGIC	0521
#define  M68MAGICF	0x8800
#define  M68TVMAGICF	0x8900
#define  MC68MAGICF	0x5001
#define  MC68TVMAGICF	0x5101

	/* u370 */

#define  U370ROMAGIC	0530
#define  U370WRMAGIC	0535
#define  U370ROMAGICF	0x5801
#define  U370WRMAGICF	0x5D01

	/* pasc 370 */

#define P370ROMAGIC	0410
#define P370ROMAGICF	0x0801
#define P370WRMAGIC	0407
#define P370WRMAGICF	0x0701
#define P370PGMAGIC	0413
#define P370PGMAGICF	0x0B01

	/* xa370 */

#define  XA370ROMAGIC	0532
#define  XA370WRMAGIC	0537
#define  XA370ROMAGICF	0x5A01
#define  XA370WRMAGICF	0x5F01

	/* n3b */

/*
 *   NOTE:   For New 3B, the old values of magic numbers
 *		will be in the optional header in the structure
 *		"aouthdr" (identical to old 3B aouthdr).
 */
#define  N3BMAGIC	0550
#define  NTVMAGIC	0551
#define  N3BMAGICF	0x6801
#define  NTVMAGICF	0x6901

	/*  XL  */
#define	 XLMAGIC	0540

	/*  MAC-32   3b-5  */
#define  M80MAGIC	0560
#define  M80MAGICF	0x7001
#define  FBOMAGIC	0560
#define  RBOMAGIC	0562

#define  MTVMAGIC	0561
#define  MTVMAGICF	0x7101


	/* VAX 11/780 and VAX 11/750 */
			/* writeable text segments */
#define VAXWRMAGIC	0570
#define VAXWRMAGICF	0x7801
			/* readonly sharable text segments */
#define VAXROMAGIC	0575
#define VAXROMAGICF	0x7D01

#define	FILHDR	struct filehdr
#define	FILHSZ	sizeof(FILHDR)

#endif /* ~_h_FILEHDR */
#ifdef __cplusplus
}
#endif
