#ifdef __cplusplus
extern "C" {
/* (MRL) I have no idea for the prototypes of the functions in this file */
#endif
/*
 *		AIX/370
 *		5713-AFL
 *	LICENSED MATERIALS - PROPERTY OF IBM
*	(c) Copyright 1985, 1986, 1989 IBM Corp.
*	(c) Copyright 1983, 1984, 1985, 1986, 1989 Locus Computing Corporation
 *	All Rights Reserved
 */

#ifndef H_SCCSID
#include <sccs.h>
#endif /* ~H_SCCSID */
H_SCCSID(@(#)map.h	16.3	LCC)	/* Modified: 20:02:21 9/15/89 */

/*
 * Resource Allocation Maps.
 *
 * Associated routines manage sub-allocation of an address space using
 * an array of segment descriptors.  The first element of this array
 * is a map structure, describing the arrays extent and the name
 * of the controlled object.  Each additional structure represents
 * a free segment of the address space.
 *
 * A call to rminit initializes a resource map and may also be used
 * to free some address space for the map.  Subsequent calls to rmalloc
 * and rmfree allocate and free space in the resource map.  If the resource
 * map becomes too fragmented to be described in the available space,
 * then some of the resource is discarded.  This may lead to critical
 * shortages, but is better than not checking (as the previous versions
 * of these routines did) or giving up and calling panic().  The routines
 * could use linked lists and call a memory allocator when they run
 * out of space, but that would not solve the out of space problem when
 * called at interrupt time.
 *
 * N.B.: The address 0 in the resource address space is not available
 * as it is used internally by the resource map routines.
 */

struct  allmapents
{
	union
	{
		struct  mapent  * UAL_mlimit;
		rmap_t  UAL_msize;
	} UAL_one;
	union
	{
		char  * UAL_mname;
		rmap_t  UAL_maddr;
	} UAL_two;
};

struct  map
{
	struct  allmapents  M_map;

#define m_limit		M_map.UAL_one.UAL_mlimit
#define m_name		M_map.UAL_two.UAL_mname
};

struct  mapent
{
	struct  allmapents  M_map;
#define m_size		M_map.UAL_one.UAL_msize
#define m_addr		M_map.UAL_two.UAL_maddr
};

#ifdef  KERNEL

extern  struct	map *swapmap;

#define	ARGMAPSIZE	16
extern  struct	map *argmap;

#if	defined(PAGING) || defined(SWAPPING)
extern  struct	map *kernelmap;
#endif  /* (PAGING || SWAPPING) */

#ifdef	b370
#ifdef	SVPAGING
extern	struct	map *sptmap;
#else	/* ~SVPAGING */
extern	struct	map *pt370map;
#endif	/* ~SVPAGING */
#endif	/* b370 */

extern struct	map *mbmap;

#if	defined(i386)
extern struct	map *coremap;
#endif	/* (i386) */

extern  rmap_t  rmalloc();

#if	defined(PAGING) || defined(SWAPPING) || defined(i386)
extern  rmap_t  rmget();
#endif	/* (PAGING || SWAPPING || i386) */

#endif  /* KERNEL */
}
