#ifdef __cplusplus
extern "C" {
/* (MRL) I have no idea for the prototypes of the functions in this file */
#endif
/*
 *		IX/370
 *		5667-126
 *	LICENSED MATERIALS - PROPERTY OF IBM
*	(c) Copyright 1985, 1986, 1989 IBM Corp.
*	(c) Copyright 1983, 1984, 1985, 1986, 1989 Locus Computing Corporation
 *	All Rights Reserved
 */

#ifndef H_SCCSID
#include <sccs.h>
#endif /* ~H_SCCSID */
H_SCCSID(@(#)msg.h	16.3	LCC)	/* Modified: 18:15:20 9/16/89 */

#ifndef _h_MSG
#define _h_MSG

#ifndef _h_IPC
#ifdef  KERNEL
#include <ipc.h>
#else  /* ~KERNEL */
#include <sys/ipc.h>
#endif /* ~KERNEL */
#endif  /* _h_IPC */

/*
**	IPC Message Facility.  Added into LOCUS by Brett Fleisch.
*/

/*
**	Implementation Constants.
*/

#define	PMSG	(PZERO + 2)	/* message facility sleep priority */

/*
**	Permission Definitions.
*/

#define	MSG_R	0400	/* read permission */
#define	MSG_W	0200	/* write permission */

/*
**	ipc_perm Mode Definitions.
*/

#define	MSG_RWAIT	01000	/* a reader is waiting for a message */
#define	MSG_WWAIT	02000	/* a writer is waiting to send */
#define	MSG_SWAIT	04000	/* select operation is waiting for something */

/*
**	Message Operation Flags.
*/

#define	MSG_NOERROR	010000	/* no error if big message */

/*
**	Structure Definitions.
*/

/*
**	There is one msg queue id data structure for each q in the system.
*/

struct msqid_ds {
	struct ipc_perm	msg_perm;	/* operation permission struct */
	struct msg	*msg_first;	/* ptr to first message on q */
	struct msg	*msg_last;	/* ptr to last message on q */
	ushort		msg_cbytes;	/* current # bytes on q */
	ushort		msg_qnum;	/* # of messages on q */
	ushort		msg_qbytes;	/* max # of bytes on q */
	pid_t		msg_lspid;	/* pid of last msgsnd */
	pid_t		msg_lrpid;	/* pid of last msgrcv */
	time_t		msg_stime;	/* last msgsnd time */
	time_t		msg_rtime;	/* last msgrcv time */
	time_t		msg_ctime;	/* last change time */
#ifdef u370
	ushort		msg_rwcnt ;	/* waiting for read count */
	ushort		msg_wwcnt ;	/* waiting for write count */
#endif /* u370 */
};

/*
**	There is one msg structure for each message that may be in the system.
*/

struct msg {
	struct msg	*msg_next;	/* ptr to next message on q */
	long		msg_type;	/* message type */
	short		msg_ts;		/* message text size */
	caddr_t		msg_spot;	/* message text address */
	time_t		msg_time;	/* time msg was sent */
	suid_t		msg_uid;	/* sender's uid */
	sgid_t		msg_gid;	/* sender's gid */
	pid_t		msg_pid;	/* sender's pid */
	long		msg_nid;	/* sender's nid */
};

/*
**	User message buffer template for msgsnd and msgrecv system calls.
*/

struct msgbuf {
	long	mtype;		/* message type */
	char	mtext[1];	/* message text */
};

struct msgxbuf {
	time_t	mtime;		/* time message was sent */
	suid_t	muid;		/* author's effective uid */
	sgid_t	mgid;		/* author's effective gid */
	unsigned long mnid;	/* author's node id */
	pid_t	mpid;		/* author's process id */
	long	mtype;		/* message type */
	char	mtext[1];	/* message text */
};

/*
**	Message information structure.
*/

struct msginfo {
	int	msgmax,	/* max message size */
		msgmnb,	/* max # bytes on queue */
		msgmni,	/* # of message queue identifiers */
		msgssz,	/* msg segment size (should be word size multiple) */
		msgtql;	/* # of system message headers */
	ushort	msgseg;	/* # of msg segments (MUST BE < 32768) */
};

#endif /* ~_h_MSG */
#ifdef __cplusplus
}
#endif
