extern "C" {
/*
 *		IX/370
 *		5667-126
 *	LICENSED MATERIALS - PROPERTY OF IBM
*	(c) Copyright 1985, 1986, 1989 IBM Corp.
*	(c) Copyright 1983, 1984, 1985, 1986, 1989 Locus Computing Corporation
 *	All Rights Reserved
 */

#ifndef _POSIX_SOURCE
#ifndef	H_SCCSID
#include <sccs.h>
#endif	/* ! H_SCCSID */
H_SCCSID(@(#)time.h	16.12	LCC)	/* Modified: 21:54:35 7/12/90 */
#endif /* NOT _POSIX_SOURCE */

#ifndef	_H_TIME
#define	_H_TIME

#ifndef _H_TYPES
#ifdef  _KERNEL
#include <types.h>
#else  /* ~_KERNEL */
#include <sys/types.h>
#endif /* ~_KERNEL */
#endif  /* _H_TYPES */

#ifndef _POSIX_SOURCE
/*
 * Structure returned by gettimeofday(2) system call,
 * and used in other calls.
 */
struct timeval {
	long	tv_sec;		/* seconds */
	long	tv_usec;	/* and microseconds */
};

struct timezone {
	int	tz_minuteswest;	/* minutes west of Greenwich */
	int	tz_dsttime;	/* type of dst correction */
};
#define	DST_NONE	0	/* not on dst */
#define	DST_USA		1	/* USA style dst */
#define	DST_AUST	2	/* Australian style dst */
#define	DST_WET		3	/* Western European dst */
#define	DST_MET		4	/* Middle European dst */
#define	DST_EET		5	/* Eastern European dst */
#define	DST_CAN		6	/* Canada */

/*
 * Operations on timevals.
 *
 * NB: timercmp does not work for >= or <=.
 */
#define	timerisset(tvp)		((tvp)->tv_sec || (tvp)->tv_usec)
#define	timercmp(tvp, uvp, cmp)	\
	((tvp)->tv_sec cmp (uvp)->tv_sec || \
	 (tvp)->tv_sec == (uvp)->tv_sec && (tvp)->tv_usec cmp (uvp)->tv_usec)
#define	timerclear(tvp)		(tvp)->tv_sec = (tvp)->tv_usec = 0

/*
 * Names of the interval timers, and structure
 * defining a timer setting.
 */
#define	ITIMER_REAL	0
#define	ITIMER_VIRTUAL	1
#define	ITIMER_PROF	2

struct	itimerval {
	struct	timeval it_interval;	/* timer interval */
	struct	timeval it_value;	/* current value */
};
#endif /* NOT _POSIX_SOURCE */

/*
 * Structure returned by gmtime and localtime calls (see ctime(3)).
 */
struct	tm {	/* see ctime(3) */
	int	tm_sec;
	int	tm_min;
	int	tm_hour;
	int	tm_mday;
	int	tm_mon;
	int	tm_year;
	int	tm_wday;
	int	tm_yday;
	int	tm_isdst;
};

#ifdef	_KERNEL
extern long timetohz();
#else	/* ! _KERNEL */
extern	struct tm *gmtime(const time_t*), *localtime(const time_t*);
extern	char *asctime(const struct tm*), *ctime(const time_t*);
extern time_t time(time_t*);                               
extern void tzset(void);
extern char *tzname[2];
#ifdef __cplusplus
/* (MRL) There were many other time related functions in the USL proto-headers.
	I have not included them here. */
#endif


#ifndef _POSIX_SOURCE
extern long timezone;
extern int daylight;

#if defined( NLS ) && !defined( RTPC_NO_NLS )
/*  Suggested default length of time/date buffer
 */
#define NLTBMAX	64

extern char *NLctime(), *NLasctime(), 
	*NLstrtime(char*, char*, int, struct tm*);
#endif /* NLS && ! RTPC_NO_NLS */
#endif /* NOT _POSIX_SOURCE */

#endif  /* ! _KERNEL */

#endif	/* ! _H_TIME */
#ifdef __cplusplus
}
#endif
