#ifdef __cplusplus
extern "C" {
#endif
#ifndef _POSIX_SOURCE
#ifndef H_SCCSID
#include <sccs.h>
#endif /* ! H_SCCSID */
H_SCCSID(@(#)tar.h	1.5       LCC)    /* Modified: 00:29:14 1/12/90 */
#endif /* NOT _POSIX_SOURCE */
/* 
 * (C) Copyright IBM Corp. 1989 
 * All Rights Reserved 
 * Licensed Materials - Property of IBM 
 */

/*	Header for POSIX tar	*/

#ifndef _H_TAR
#define _H_TAR

#define TMAGIC	"ustar" 	/*	ustar and a null	*/
#define TMAGLEN		6
#define TVERSION	"00"
#define TVERSLEN	2

/*	Values used in typeflag field	*/
#define REGTYPE		'0'	/* Regular file	*/
#define AREGTYPE	'\0'	/* Regular file	*/
#define LNKTYPE		'1'	/* Link		*/
#define SYMTYPE		'2'	/* Reserved	*/
#define CHRTYPE		'3'	/* Character special	*/
#define BLKTYPE		'4'	/* Block special*/
#define DIRTYPE		'5'	/* Directory	*/
#define FIFOTYPE	'6'	/* FIFO special	*/
#define CONTTYPE	'7'	/* Reserved	*/
/*	Values used in typeflag field -- AIX specific 	*/
#ifndef _POSIX_SOURCE
#define HDIRTYPE 	'H'	/* Hidden directory 	*/
#endif /* _POSIX_SOURCE */

/*	Bits used in the mode field - values in octal	*/
#define	TSUID		04000	/* Set UID on execution	*/
#define	TSGID		02000	/* Set GID on execution	*/
#define	TSVTX		01000	/* Reserved	*/
				/* File permissions	*/
#define	TUREAD		00400	/* read by owner	*/
#define	TUWRITE		00200	/* write by owner	*/
#define	TUEXEC		00100	/* execute/search by owner	*/
#define	TGREAD		00040	/* read by group	*/
#define	TGWRITE		00020	/* write by group	*/
#define	TGEXEC		00010	/* execute/search by group	*/
#define	TOREAD		00004	/* read by other	*/
#define	TOWRITE		00002	/* write by other	*/
#define	TOEXEC		00001	/* execute/search by other	*/

#ifndef _POSIX_SOURCE
#define TBLOCK 512
#define NAMSIZ	100

union hblock {
	char dummy[TBLOCK];      /* this just makes it be the right length */
	struct header {         /* this is the real info */
		char name[NAMSIZ];      /* pathname - rel. or abs. */
		char mode[8];           /* octal digits */
		char uid[8];
		char gid[8];
		char size[12];
		char mtime[12];
		char chksum[8];
		char typeflag;
		char linkname[NAMSIZ];
		char magic[TMAGLEN];
		char version[2];
		char uname[32];
		char gname[32];
		char devmajor[8];
		char devminor[8];
		char prefix[155];
	} dbuf;
} dblock;

#endif /* _POSIX_SOURCE */

#endif	/* tar.h	*/
#ifdef __cplusplus
}
#endif
