#ifdef __cplusplus
extern "C" {
#endif
#ifndef _POSIX_SOURCE
#ifndef H_SCCSID
#include <sccs.h>
#endif /* ! H_SCCSID */
H_SCCSID(@(#)termios.h	1.12       LCC)    /* Modified: 15:08:10 11/9/90 */
#endif /* NOT _POSIX_SOURCE */
/* 
* Copyright (C)  1989, Locus Computing Corporation
 * All Rights Reserved
 */ 
/* 
 * (C) Copyright IBM Corp. 1989 
 * All Rights Reserved 
 * Licensed Materials - Property of IBM 
 */

#ifndef	_H_TERMIOS
#define	_H_TERMIOS

#include <sys/ioctl.h>

#ifndef _KERNEL

#if defined(_h_TERMIO) && !defined(_POSIX_SOURCE)
		/* if user includes both termio.h and termios.h,
		  * which is not allowed, cause an error here!
		  */
<<<< Use only one termioX.h file: struct termio already defined >>>>
#endif /* _h_TERMIO && NOT _POSIX_SOURCE */

#include <sys/types.h>

/* input modes, this is subset of input modes defined in <termio.h>
   make sure the bits are defined the same, otherwise the compile of 
   posix interface library routines will fail.			 */
#define	IGNBRK	0000001
#define	BRKINT	0000002
#define	IGNPAR	0000004
#define	PARMRK	0000010
#define	INPCK	0000020
#define	ISTRIP	0000040
#define	INLCR	0000100
#define	IGNCR	0000200
#define	ICRNL	0000400
#define	IXON	0002000
#define	IXOFF	0010000

/* output modes, this is subset of input modes defined in <termio.h> */
#define	OPOST	0000001

/* control modes */
#define	B0		0		/* speed 0 */
#define	B50		0000001		/* speed 1 */
#define	B75		0000002		/* speed 2 */
#define	B110		0000003		/* speed 3 */
#define	B134		0000004		/* speed 4 */
#define	B150		0000005		/* speed 5 */
#define	B200		0000006		/* speed 6 */
#define	B300		0000007		/* speed 7 */
#define	B600		0000010		/* speed 8 */
#define	B1200		0000011		/* speed 9 */
#define	B1800		0000012		/* speed 10 */
#define	B2400		0000013		/* speed 11 */
#define	B4800		0000014		/* speed 12 */
#define	B9600		0000015		/* speed 13 */
#define	B19200		0000016		/* speed 14 */
#define	B38400		0000017		/* speed 15 */

#ifndef _POSIX_SOURCE
#define	EXTA		0000016
#define	EXTB		0000017
#define	CBAUD		0000017
#endif	/* NOT _POSIX_SOURCE */

#define	CSIZE		0000060
#define	CS5		0
#define	CS6		0000020
#define	CS7		0000040
#define	CS8		0000060
#define	CSTOPB		0000100
#define	CREAD		0000200
#define	PARENB		0000400
#define	PARODD		0001000
#define	HUPCL		0002000
#define	CLOCAL		0004000

/* local modes, this is mostly subset of input modes defined in <termio.h>.
   Some bits are missing because they are defined to be something else in
   <termio.h>.
   New defines are IEXTEN and TOSTOP.  They are new for POSIX.  TOSTOP is
   Berkeley equivalent of LTOSTOP.  A different TOSTOP is defined in
   sgtty.h if BSD and !_KERNEL.  However, I don't think it ever gets used
   that way.  								*/

/* line discipline 0 modes */
#define	ISIG	0000001
#define	ICANON	0000002
#define	ECHO	0000010
#define	ECHOE	0000020
#define	ECHOK	0000040
#define	ECHONL	0000100
#define	NOFLSH	0000200
#define IEXTEN	0001000


/* Note:  some of these symbols would conflict with the System-V
 *        symbols in <sys/termio.h>, but since the POSIX interface
 *        is all-encompassing, the user will never need both these
 *        defines and the old ones at the same time.  The actual
 *        conflicts are called out in the comments
 */

#define	VINTR 		0	/* interrupt */
#define	VQUIT 		1	/* quit */
#define	VERASE		2	/* erase last character */
#define	VKILL		3	/* erase entire line */

/* NOTE: fields 4 and 5 are meaningless with POSIX interface */
#ifndef _POSIX_SOURCE
#define	VEOL2		6	/* Sys5: 2nd input delimiter sys5 only */
#define	VS5RESERVE	7	/* Sys5: reserved for future use */
#endif	/* NOT _POSIX_SOURCE */

/* NOTE: these "VMIN/TIME/EOF/EOL" defines do NOT match the SysV ones */
#define	VMIN		8	/* Sys5: minimum chars per read (!ICANON) */
#define	VTIME		9	/* Sys5: time before returning read (!ICANON) */
#define	VSTART		10	/* 4bsd: start output */
#define	VSTOP		11	/* 4bsd: stop output */
#define	VSUSP		12	/* 4bsd: stop process signal */

#ifndef _POSIX_SOURCE
#define	VDSUSP		13	/* 4bsd: delayed stop process signal */
#define	VRPRNT		14	/* 4bsd: reprint line */
#define	VFLUSH		15	/* 4bsd: flush output (toggles) */
#define	VWERASE		16	/* 4bsd: word erase */
#define	VLNEXT		17	/* 4bsd: literal next character */
#define	VSTAT		18	/* ucla: report system load */
#define	VPAGE		19	/* ucla: display next page of output */
#define	VPGOFF		20	/* ucla: disable paging until next input */

#define	VBRK		VEOL	/* brk is bsd's name for eol */
#endif	/* NOT _POSIX_SOURCE */
#define	VEOF		21	/* eof char */
#define	VEOL		22	/* input delimiter like '\n' */

#endif /* NOT _KERNEL */

#define	TOSTOP	0002000

typedef unsigned short	tcflag_t;
typedef unsigned char	cc_t;
#ifdef _MBCS
typedef unsigned int	speed_t;
#else	/* ~ _MBCS */
typedef unsigned short	speed_t;
#endif	/* ~ _MBCS */

/*
 * "POSIX" control structure; also TIOCxPSX Ioctl control packet
 */

#define	NCCS	23

struct termios {
/* posix minimum set (along with c_cc below) */
	tcflag_t 	c_iflag;	/* input modes */
	tcflag_t 	c_oflag;	/* output modes */
	tcflag_t 	c_cflag;	/* control modes */
	tcflag_t 	c_lflag;	/* SYSV local modes */
/* additional supported modes */
	tcflag_t	c_reserved[4];	/* for future expansion */
	tcflag_t	c_bflag;	/* 4bsd: newtty line discipline modes */
#ifdef _POSIX_SOURCE
	struct _Winsize c_winsize;	/* window size */
#else
	struct winsize	c_winsize;	/* window size */
#endif
	char		c_length;	/* vertical screen length */
	char		c_pgflag;	/* paging and bell-ringing flags */
	char		c_line;		/* line discipline */
	cc_t 		c_cc[NCCS];	/* control chars */
};


#ifndef _KERNEL

/*
 * BERKELEY newtty line discipline modes (c_bflag)
 */
#ifndef _POSIX_SOURCE
#define	LCRTBS	0000001		/* correct backspacing for crt */
#define	LPRTERA 0000002		/* printing terminal \ ... / erase */
#define	LTILDE	0000010		/* IIASA - hazeltine tilde kludge */
#define	LMDMBUF	0000020		/* IIASA - start/stop output on carrier intr */
#define	LLITOUT	0000040		/* IIASA - suppress any output translations */
#define	LFLUSHO	0000200		/* flush output sent to terminal */
#define	LETXACK 0001000		/* IIASA - diablo style buffer hacking */
#define	LCRTKIL	0002000		/* erase whole line on kill with "\b \b" */
#define	LPASS8  0004000		/* allow all 8 bits to pass through on input */ 
#define	LCTLECH	0010000		/* echo control characters as ^X */
#endif	/* NOT _POSIX_SOURCE */


#define TCSANOW		0
#define	TCSADRAIN	1
#define TCSAFLUSH	2

/* Queue selectors for tcflush routine */
#define TCIFLUSH	0
#define TCOFLUSH	1
#define TCIOFLUSH	2

/* TCFLOW actions */
#define	TCOOFF	0
#define	TCOON	1
#define	TCIOFF	2
#define	TCION	3

/* POSIX forward declarations. */
extern	int	tcgetattr();
extern	int	tcsetattr();
extern	int	tcsendbreak();
extern	int	tcdrain();
extern	int	tcflush();
extern	int	tcflow();
extern	speed_t	cfgetospeed();
extern	speed_t	cfgetispeed();
extern	int	cfsetospeed();
extern	int	cfsetispeed();

#endif /* NOT _KERNEL */

#endif /*_H_TERMIOS */
#ifdef __cplusplus
}
#endif
