#ifdef __cplusplus
extern "C" {
#endif
#ifndef H_SCCSID
#include <sccs.h>
#endif /* ~H_SCCSID */
H_SCCSID(@(#)usem.h	1.8	AIX)	/* Modified 9/17/89 01:55:25 */
/*      @(#)usem.h	1.2 u370  source        */
/* 
 * (C) Copyright IBM Corp. 1989 
 * All Rights Reserved 
 * Licensed Materials - Property of IBM 
 */
/* This file includes general definitions used in USEM.  */

#define CFILE		"/usr/sm/lib/smlines"
#define	MUXFILE		"/usr/sm/lib/muxlines"
#define	ACUFILE		"/usr/sm/lib/aculines"
#define	NFILE		"/usr/sm/lib/system_names"
#define SFILE		"/usr/sm/lib/smstate"
#define	S_MSGDIR 	"/usr/sm/msgs/"
#define	G_MSGFILE	"/usr/sm/msgs/general"

/* return values.  General values are > -10.
**		   Controller values are <= -10.
*/
#define GOOD		0
#define BAD		1
				/* don't use EOF(-1) to avoid conflicts	*/
#define	NOCONFIG	-2	/* unable to open configuration file	*/
#define	BADCONFIG	-3	/* bad configuration file		*/
#define	ALREADY_RUN	-4	/* process is already running		*/
#define	BAD_NAME	-5	/* acuslav given a bad system name	*/
#define	NOMUX		-10	/* no mux to sync with			*/
#define	NOSLAVE		-11	/* no slave to sync with		*/
#define NOCONNECT	-12	/* could not connect via acu		*/
#define	NOCARRIER	-13	/* no carrier detect found on acu line	*/
#define	NOACUOPEN	-14	/* could not open acu line		*/
#define	NOTTYOPEN	-15	/* could not open line to tty for acu's	*/
#define	NOTHING_READ	-16	/* sync did not read anything from slav	*/
#define	ECHOING		-17	/* slave is echoing sync characters	*/
#define	NOTRY		-18	/* did not try to sync this time	*/
#define	TEMP_NO_READ	-19	/* got a temporary NOTHING_READ		*/

#define INTERVAL 	120	/* default polling interval 		*/

/* Configuration File defines */
#define	MAX_SYS_PER_MUX	32		/* max # systems/mux		*/
#define CFSIZE		200		/* max # systems -- this should	*/
					/* really be a dynamic array	*/
#define CFTYPE 	 	10		/* smcont, acucont, etc		*/
#define	IS_MUX		"mux00"		/* IS_MUX and IS_ACU are used in*/
#define	IS_ACU		"acu00"		/* the 'talk' field of smlines  */
#define	TALK_SIZE	3		/* only strncmp() first 3 chars	*/
#define CFTALK		6 		/* sizeof(IS_ACU and IS_MUX)+1	*/
#ifdef	MYNAME
#define	CFNAME		sizeof(MYNAME)
#else
#define CFNAME		9		/* size of system nodename	*/
#endif
#define CFLINE		7		/* sizeof(tty000) + 1		*/
#define CFPHONE		14		/* sizeof("13122601064-<") + 1	*/

typedef	enum	boolean {false, true} boolean;

struct config {
	char	type[CFTYPE];		/* controller or slave		*/
	char	name[CFNAME];		/* system name, e.g. "ihuxa"	*/
	char	line[CFLINE];		/* e.g. "tty000"		*/
	int	baud;			/* baud rate line is at		*/
	char	talk[CFTALK];		/* IS_MUX or IS_ACU		*/
	/* the following are used only if IS_ACU */
	char	modem_line[CFLINE];	/* tty to modem			*/
	char	acu_line[CFLINE];	/* tty to acu			*/
	char	phone_num[CFPHONE];	/* phone number			*/
	int	use_external;		/* use ext. password?  (0 or 1)	*/
	int	num_breaks;		/* # breaks to send to get baud	*/
};

/* status states */
#define	IS_UP		'U'		/* operating normally		*/
#define IS_DOWN		'D'		/* down				*/
#define ERROR		'E'		/* status error (NSC, RJE)	*/
#define	TIME_ERROR	-1L		/* status error (tstamp)	*/
#define N_ERROR		-1		/* status error for numbers	*/

struct rje {
	char	state;			/* one of the above states	*/
	short	njobs;			/* number of jobs queued 	*/
	long	tstamp;			/* time stamp of info		*/
};

struct nsc {
	char	state;			/* one of the above states	*/
	short	njobs;			/* number of jobs		*/
	long	tstamp;			/* time stamp of info		*/
};

struct phones {
	short	custom;			/* number of custom lines left	*/
	short	cornet;			/* "	"    cornet " "   	*/
	short	external;		/* "	"    external " "   	*/
	long	tstamp;			/* time stamp of lines info 	*/
};

/* Global structure of ALL information about a system.  Some info
** may not be used for all systems; it will be initialized and
** written/read to/from the pipe, but never displayed.  Writting
** one record with all the info, but possibly ignoring some of it,
** is more efficient than writting multiple records, one for each
** type of info.
*/
struct stat_rec {
	char		sname[CFNAME];	/* system's name		*/
	int		state;		/* GOOD, BAD, NOSLAVE, etc	*/
	long		tstamp;		/* when we last got any info	*/
	struct	nsc	n;
	struct	phones	p;
	struct	rje	r;
};

#define	MAX_GSMSG_LENGTH	79	/* general/status message length*/
/* general message structure */
struct	g_info {
	long	expire_time;		/* time it expires		*/
	boolean	remove_expired;		/* should message expire?	*/
	char	msg[MAX_GSMSG_LENGTH];	/* actual message		*/
};
#ifdef __cplusplus
}
#endif
