#ifdef __cplusplus
extern "C" {
#endif
/*
 *		IX/370
 *		5667-126
 *	LICENSED MATERIALS - PROPERTY OF IBM
*	(c) Copyright 1985, 1986, 1989 IBM Corp.
*	(c) Copyright 1983, 1984, 1985, 1986, 1989 Locus Computing Corporation
 *	All Rights Reserved
 */

#ifndef H_SCCSID
#include <sccs.h>
#endif /* ~H_SCCSID */
H_SCCSID(@(#)ustat.h	16.3	LCC)	/* Modified: 19:36:26 9/16/89 */

#ifndef	_h_USTAT
#define	_h_USTAT

#ifndef _h_TYPES
#ifdef  KERNEL
#include <types.h>
#else  /* ~KERNEL */
#include <sys/types.h>
#endif /* ~KERNEL */
#endif /* ~_h_TYPES */

/*	@(#)ustat.h	1.1	*/
/*	3.0 SID #	1.1	*/
struct  ustat {
	daddr_t	f_tfree;	/* total free */
	ino_t	f_tinode;	/* total inodes free */
	char	f_fname[6];	/* filsys name */
	char	f_fpack[6];	/* filsys pack name */
};

#if defined(i386) && defined(X286PROCS)
/* ustat structure fields align the same, but 386 gets padded to 4 byte
** boundary at the end, so it's size is larger. 
*/

/* xustat is here just so ustat can figure out the right size for the structure
** to copy back to x286procs.
*/
struct xustat {
	char xustatc[6+6+sizeof(ino_t)+sizeof(daddr_t)];
};
#endif /* defined(i386) && defined(X286PROCS) */
#ifdef __cplusplus
	int ustat(int, struct ustat*);
#endif

#endif /* ~_h_USTAT */
#ifdef __cplusplus
}
#endif
