#ifdef __cplusplus
extern "C" {
#endif
/*
 *		IX/370
 *		5667-126
 *	LICENSED MATERIALS - PROPERTY OF IBM
 *	(c) Copyright 1985, 1986, 1989 IBM Corp.
 *	(c) Copyright 1983, 1984, 1985, 1986,  1989 Locus Computing Corporation
 *	All Rights Reserved
 */

#ifndef _POSIX_SOURCE
#ifndef H_SCCSID
#include <sccs.h>
#endif /* ~H_SCCSID */
H_SCCSID(@(#)wait.h	16.6.1.1       LCC)    /* Modified: 23:06:30 7/22/90 */
#endif /* NOT _POSIX_SOURCE */

#ifndef _H_WAIT
#define _H_WAIT

#include <sys/types.h>

#ifndef _POSIX_SOURCE
#include <DOPTIONS.h>

/*
 * This file holds definitions relevent to the wait system call.
 * Some of the options here are available only through the ``wait3''
 * entry point; the old entry point with one argument has more fixed
 * semantics, never returning status of unstopped children, hanging until
 * a process terminates if any are outstanding, and never returns
 * detailed information about process resource utilization (<vtimes.h>).
 *
 * Structure of the information in the first word returned by both
 * wait and wait3.  If w_stopval==WSTOPPED, then the second structure
 * describes the information returned, else the first.  See WUNTRACED below.
 */

union wait	{
	int	w_status;		/* used in syscall */
	/*
	 * Terminated process status.
	 */
	struct {
#ifdef	BITSHI
		unsigned int	w_Pad1:16;	/* pad to long */
		unsigned int	w_Retcode:8;	/* exit code if w_termsig==0 */
		unsigned int	w_Coredump:1;	/* core dump indicator */
		unsigned int	w_Termsig:7;	/* termination signal */
#else	/* BITSHI- */
		unsigned short	w_Termsig:7;	/* termination signal */
		unsigned short	w_Coredump:1;	/* core dump indicator */
		unsigned short	w_Retcode:8;	/* exit code if w_termsig==0 */
		unsigned int	w_Pad1:16;	/* pad to long */
#endif	/* BITSHI- */
	} w_T;
	/*
	 * Stopped process status.  Returned
	 * only for traced children unless requested
	 * with the WUNTRACED option bit.
	 */
	struct {
#ifdef	BITSHI
		unsigned int	w_Pad2:16;	/* pad to long */
		unsigned short	w_Stopsig:8;	/* signal that stopped us */
		unsigned short	w_Stopval:8;	/* == W_STOPPED if stopped */
#else	/* BITSHI- */
		unsigned short	w_Stopval:8;	/* == W_STOPPED if stopped */
		unsigned short	w_Stopsig:8;	/* signal that stopped us */
		unsigned int	w_Pad2:16;	/* pad to long */
#endif	/* BITSHI- */
	} w_S;
};
#define	w_termsig	w_T.w_Termsig
#define w_coredump	w_T.w_Coredump
#define w_retcode	w_T.w_Retcode
#define w_stopval	w_S.w_Stopval
#define w_stopsig	w_S.w_Stopsig

#define	WSTOPPED	0177	/* value of s.stopval if process is stopped */

#endif /* NOT _POSIX_SOURCE */

/*
 * Option bits for the second argument of wait3.  WNOHANG causes the
 * wait to not hang if there are no stopped or terminated processes, rather
 * returning an error indication in this case (pid==0).  WUNTRACED
 * indicates that the caller should receive status about untraced children
 * which stop due to signals.  If children are stopped and a wait without
 * this option is done, it is as though they were still running... nothing
 * about them is returned.
 */
#define WNOHANG		1	/* dont hang in wait */
#define WUNTRACED	2	/* tell about stopped, untraced children */


#ifdef _POSIX_SOURCE

/* The following macros are defined without the use of 'struct wait' because
 * that structure isn't to be visible to POSIX.  These macros return the same
 * values as their counterparts below.  In particular,
 *   WIFSTOPPED  returns TRUE if the low byte has the value 0177.
 *   WIFSIGNALED returns TRUE if the low byte is not 0177 and
 *		the next byte is non zero.
 *   WIFEXITED returns TRUE if the low byte is not 01777 and
 *              the next byte is zero.
 *   WTERMSIG returns the low 7 bits.
 *   WSTOPSIG returns the value of the low byte.
 *   WEXITSTATUS returns the value of the next byte.
 */
#define	_WSTOPPED	0177	/* value of s.stopval if process is stopped */

#define WIFSTOPPED(x)	((((int)(x))&0377) == _WSTOPPED)
#define WIFSIGNALED(x)	(!WIFSTOPPED(x) && (((int)(x))&0177) != 0)
#define WIFEXITED(x)	(!WIFSTOPPED(x) && (((int)(x))&0177) == 0)
#define WEXITSTATUS(x)	(((int)(x)>>8)&0377)
#define WTERMSIG(x)	(((int)(x))&0177)
#define WSTOPSIG(x)	(((int)(x)>>8)&0377)

#else	/* NOT _POSIX_SOURCE */

#define WIFSTOPPED(x)	((*(union wait *) &(x)).w_stopval == WSTOPPED)
#define WIFSIGNALED(x)	((*(union wait *) &(x)).w_stopval != WSTOPPED && (*(union wait *) &(x)).w_termsig != 0)
#define WIFEXITED(x)	((*(union wait *) &(x)).w_stopval != WSTOPPED && (*(union wait *) &(x)).w_termsig == 0)
#define WEXITSTATUS(x)	((*(union wait *) &(x)).w_T.w_Retcode)
#define WTERMSIG(x)	((*(union wait *) &(x)).w_T.w_Termsig)
#define WSTOPSIG(x)	((*(union wait *) &(x)).w_S.w_Stopsig)

#endif	/* NOT _POSIX_SOURCE */

#ifndef _KERNEL
extern pid_t  wait(int);                    
extern pid_t  waitpid(pid_t, int *, int);
/* (MRL) I have added waitid() here */
extern int waitid(idtype_t, id_t, siginfo_t *, int);                    
#endif	/* NOT _KERNEL */
#endif	/* NOT _H_WAIT */
#ifdef __cplusplus
}
#endif
