-- Alt-1.E   Bells & whistles for the Alt-1 key.   Bryan Lewis  03/08/87
--
-- I use the Alt-1 key a lot, to edit the file named in the current text line.
-- Very handy along with the commands LIST and SCAN, and with source code.
-- I've jazzed it up so I can hit it when working with:
--
--   1. Lists output by SCAN.COM (see SCAN.E), in the form:
--        --- c:\e3\mykeys.e    3/4/87 1:04p  21136 ---
--   2. E3 source which contains lines like:
--        include 'colors.e'
--   3. C source which contains lines like:
--        #include <dos.h>
--   4. Any old list of filenames to which I've added comments.
--      All text after the filename is ignored.
--   5. Cross-reference lists output by C-USED.
--   6. File lists from the host.
--   7. Lists output by GREP with filenames like "File #0==> CKEYSEL.E <==".
--
--- History, latest change first ----------------------------------------------
--
-- Modified 8/9/88 by jbl:  Alt-One will search along a user-specified path.
-- You need this if you usually store your include files somewhere other than
-- the current directory.  I borrowed code from the USE_APPEND feature of
-- standard E (by Ken Kahn, Larry Margolis, and me).
--
-- This is good for editing C or E programs when the include files lie in a
-- different directory, for example:
--
--    #include "foo.e"
--
-- Alt-One will look first in the current directory and then along the path
-- specified by the ESEARCH environmewnt variable.  For instance, you might do:
--
--    C> set esearch=c:\current\et;d:\old\include
--
-- A special feature for C programmers:  If you turn on the constant C_INCLUDE,
-- filenames enclosed in angle brackets will not be looked for in the current
-- directory but along the path specified by the INCLUDE environment variable.
--
-- The ESEARCH feature works for any list of filenames, not just source code.
--
-------------------------------------------------------------------------------
-- Modified 10/19/87 by Chris Codella to handle tryincludes and includes not
-- starting in column 1, and includes with imbedded blanks.  10/19/87
-------------------------------------------------------------------------------
-- Modified by Bryan Lewis to handle lines in a cross-reference listing
-- produced by C-USED, resembling:
--
--   statement                               36 STAT.C
--     1 stat                                31 MAIN.C
--
-- If I press Alt-1 on the first line I want to edit STAT.C and search for the
-- word "statement".  For the second line I want to edit MAIN.C and search for
-- "stat" (the containing function) and then "statement".  I don't trust the
-- line numbers to stay constant.
-- I turn on this feature if the filetype is "USE" or "XRF".
-------------------------------------------------------------------------------

def a_1=
   /* edit filename on current text line */
   getline line

   -- jbl 2/14/89:  we now distribute a standard front end for the DIR
   -- command, which redirects the output to a file named ".dos dir <dirname>".
   -- lam 3/15/89:  added code to handle trailing blanks and wildcards.
   -- Previously, after a 'DIR \path\*.E ', would do:  E \path\*.E \fname.ext

   parse value .filename with word1 word2 word3 .
   if word1 = '.ls' then /*@@ in aixps2 I use .ls, not .DOS DIR */
      fname=word2 ||                           -- Start with the path.
	   substr(FILESEP, 1,                  -- Append a '\', but only if path
	   FILESEP<>substr(word2,length(word2),1)) ||  -- doesn't end with one.
	   strip(line)
      call a1load(fname,AltOnePathVar,0)
      return
   endif

   -- jbl 11/15/88:  The C compiler error line can have a line number in
   -- parentheses, like "/epm/i/iproto.h(196)".  Get the number.
   linenum=''
   p=pos('(',line)
   if p>0 then
      parse value line with line '(' linenum ')' .
   endif

   /** If line starts with 'include' or '#include', read the filename. **/
   pathvar = AltOnePathVar      -- default, if not #include <>
   TryCurFirst=1
   -- jbl 10/25/88:  don't accept "include" anywhere in the line, you'll be
   -- fooled by path names like c:\c\include.  Accept it only as first word.
   -- inclpos=pos('include',lowcase(line))
   parse value lowcase(line) with word1 word2 .
   if word1="include" or word1="#include" or word1="tryinclude" then
      delim=substr(word2,1,1)
      if delim="'" | delim='"' then
	 line =strip(word2,'B',delim)    /* For E files */
      elseif delim='<' then
	 parse value word2 with '<'word2'>'
	 -- jbl 10/25/88:  Searching only along the INCLUDE path didn't always
	 -- work.  Rechecking the C compiler manual, I see that it first
	 -- searches the specified search path (i.e., what we call ESEARCH) and
	 -- then the "standard directories", the INCLUDE path.
	 call a1load(word2,PathVar,TryCurFirst)  -- So first search ESEARCH.

	 -- If that fails, try INCLUDE path.
	 if rc=sayerror("New file") or rc=sayerror("Path not found") then
	    'q'
	    pathvar='INCLUDE'
	    TryCurFirst=0
	    call a1load(word2,PathVar,TryCurFirst)
	 endif

      endif
   else
      /** If line starts with fillers (duplicate characters and a space) like: **/
      /**   --- FOOBAR.TXT    (which is from SCAN), strip them off.  JBL       **/
      c=substr(line,1,1)
      temp = strip(line,'L',c)
      /* Must be a space after the fillers, and more than one filler. */
      if substr(temp,1,1)=' ' and length(temp)<length(line)-1 then
	 line=temp          --LAM: Leading blank will be stripped by Parse, below.
      endif
      /**  end of strip-leading-fillers modification  **/
   endif

   /* also discard remainder of line after the first word, so I can comment */
   parse value line with line .
   call a1load(line,PathVar,TryCurFirst)
   if rc=sayerror("New file") then
      sayerror 'Not found'
      stop
   endif
   linenum  -- jbl 11/15/88, go to specified linenum if any.


defproc a1load(filename,PathVar,TryCurFirst)
   /* jbl for aixps2:  I took out the AppendPath stuff because I don't */
   /* have a Get_Env() for AIX.  If I ever put it back in, remember to */
   /* use PATHSEP rather than a hardwired ';' as in:                   */
   /*  parse value AppendPath with TryDir ';' AppendPath               */
      'e' filename
      if rc=sayerror("New file") then
	'q'
	sayerror "Can't find "filename
      endif
